/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.ArrayList;
import java.util.Iterator;
import org.jbpm.workflow.instance.impl.WorkItemHandlerParamResolver;

public class JsonPathResolver
implements WorkItemHandlerParamResolver {
    private static final Configuration jsonPathConfig = Configuration.builder().mappingProvider((MappingProvider)new JacksonMappingProvider()).jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).build();
    private String jsonPathExpr;

    public JsonPathResolver(String jsonPathExpr) {
        this.jsonPathExpr = jsonPathExpr;
    }

    public Object apply(Object context) {
        JsonNode node = (JsonNode)JsonPath.using((Configuration)jsonPathConfig).parse(context).read(this.jsonPathExpr, JsonNode.class, new Predicate[0]);
        return this.readValue(node);
    }

    private Object readValue(JsonNode node) {
        switch (node.getNodeType()) {
            case NUMBER: {
                if (node.isInt()) {
                    return node.asInt();
                }
                if (node.isLong()) {
                    return node.asLong();
                }
                return node.asDouble();
            }
            case BOOLEAN: {
                return node.asBoolean();
            }
            case NULL: {
                return null;
            }
            case ARRAY: {
                return this.readArray((ArrayNode)node);
            }
        }
        return node.asText();
    }

    private Object readArray(ArrayNode node) {
        Iterator elements = node.elements();
        ArrayList<Object> result = new ArrayList<Object>();
        while (elements.hasNext()) {
            result.add(this.readValue((JsonNode)elements.next()));
        }
        return result;
    }
}

