/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.actions;

import com.fasterxml.jackson.databind.JsonNode;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.workflow.instance.NodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;
import org.kie.kogito.internal.process.runtime.MessageException;
import org.kie.kogito.serverless.workflow.actions.BaseExpressionAction;

public class ErrorExpressionAction
extends BaseExpressionAction {
    public ErrorExpressionAction(String lang, String expr, String inputVar) {
        super(lang, expr, inputVar);
    }

    public void execute(KogitoProcessContext context) throws Exception {
        if (this.expr.isValid()) {
            String errorStr;
            JsonNode error = this.evaluate(context, JsonNode.class);
            if (!error.isNull() && error.isTextual() && !(errorStr = error.asText()).isBlank()) {
                this.setError(context, errorStr);
            }
        } else {
            this.setError(context, "The expression used for generating error message is not a valid one: " + this.expr.asString());
        }
    }

    private void setError(KogitoProcessContext context, String message) {
        ((ProcessInstance)context.getProcessInstance()).setErrorState((NodeInstance)context.getNodeInstance(), (Exception)new MessageException(message));
    }
}

