/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.actions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jbpm.workflow.core.WorkflowModelValidator;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaValidator
implements WorkflowModelValidator,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(JsonSchemaValidator.class);
    protected JsonNode jsonNode;
    protected boolean failOnValidationErrors;
    private final transient AtomicReference<JsonSchema> schemaObject = new AtomicReference();

    public JsonSchemaValidator() {
    }

    public JsonSchemaValidator(JsonNode jsonNode, boolean failOnValidationErrors) {
        this.jsonNode = jsonNode;
        this.failOnValidationErrors = failOnValidationErrors;
    }

    public void validate(Map<String, Object> model) {
        Set report = this.getSchema().validate((JsonNode)model.getOrDefault("workflowdata", NullNode.instance));
        if (!report.isEmpty()) {
            StringBuilder sb = new StringBuilder("There are JsonSchema validation errors:");
            report.forEach(m -> sb.append(System.lineSeparator()).append(m.getMessage()));
            String validationMessage = sb.toString();
            logger.warn(validationMessage);
            if (this.failOnValidationErrors) {
                throw new IllegalArgumentException(validationMessage);
            }
        }
    }

    public <T> Optional<T> schema(Class<T> clazz) {
        return JsonNode.class.isAssignableFrom(clazz) ? Optional.of(clazz.cast(this.getSchema().getSchemaNode())) : Optional.empty();
    }

    private JsonSchema getSchema() {
        JsonSchema result = this.schemaObject.get();
        if (result == null) {
            result = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V7).getSchema(this.jsonNode);
            this.schemaObject.set(result);
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.failOnValidationErrors);
        out.writeUTF(ObjectMapperFactory.get().writeValueAsString((Object)this.jsonNode));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.failOnValidationErrors = in.readBoolean();
        this.jsonNode = ObjectMapperFactory.get().readTree(in.readUTF());
    }
}

