/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Optional;
import java.util.function.Function;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;
import org.kie.kogito.jackson.utils.JsonObjectUtils;
import org.kie.kogito.jackson.utils.MergeUtils;
import org.kie.kogito.serverless.workflow.utils.SecretResolverFactory;

public class ExpressionHandlerUtils {
    private static final String EXPR_PREFIX = "${";
    private static final String EXPR_SUFFIX = "}";
    protected static final String SECRET_MAGIC = "$SECRET.";
    protected static final String CONST_MAGIC = "$CONST.";

    private ExpressionHandlerUtils() {
    }

    public static String prepareExpr(String expr, Optional<KogitoProcessContext> context) {
        Optional<JsonNode> node = context.map(c -> (JsonNode)c.getProcessInstance().getProcess().getMetaData().get("customConstants"));
        expr = ExpressionHandlerUtils.replaceMagic(expr, SECRET_MAGIC, SecretResolverFactory.getSecretResolver());
        return node.isPresent() ? ExpressionHandlerUtils.replaceMagic(expr, CONST_MAGIC, key -> ExpressionHandlerUtils.getConstant(key, (JsonNode)node.get())) : expr;
    }

    private static Object getConstant(String key, JsonNode node) {
        JsonNode result = node;
        for (String name : key.split("\\.")) {
            result = result.get(name);
        }
        return JsonObjectUtils.toJavaValue((JsonNode)result);
    }

    private static <T> String replaceMagic(String expr, String magic, Function<String, T> replacer) {
        int indexOf;
        while ((indexOf = expr.indexOf(magic)) != -1) {
            String key = ExpressionHandlerUtils.extractKey(expr, indexOf + magic.length());
            T value = replacer.apply(key);
            if (value == null) continue;
            expr = expr.replace(magic + key, value.toString());
        }
        return expr;
    }

    private static String extractKey(String expr, int indexOf) {
        char ch;
        StringBuilder sb = new StringBuilder();
        for (int i = indexOf; i < expr.length() && (Character.isAlphabetic(ch = expr.charAt(i)) || ch == '.'); ++i) {
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String trimExpr(String expr) {
        if ((expr = expr.trim()).startsWith(EXPR_PREFIX) && (expr = expr.substring(EXPR_PREFIX.length())).endsWith(EXPR_SUFFIX)) {
            expr = expr.substring(0, expr.length() - EXPR_SUFFIX.length());
        }
        return expr.trim();
    }

    public static void assign(JsonNode context, JsonNode target, JsonNode value, String expr) {
        Optional<String> varName;
        if (context.isObject() && (varName = ExpressionHandlerUtils.fallbackVarToName(expr)).isPresent()) {
            JsonObjectUtils.addToNode((String)varName.get(), (Object)MergeUtils.merge((JsonNode)value, (JsonNode)target), (ObjectNode)((ObjectNode)context));
        }
    }

    public static Optional<String> fallbackVarToName(String expr) {
        int indexOf = expr.lastIndexOf(46);
        return indexOf < 0 ? Optional.empty() : Optional.of(expr.substring(indexOf + 1));
    }
}

