/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jbpm.process.core.ContextResolver;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.instance.ContextableInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.kie.api.definition.process.Node;
import org.kie.api.runtime.process.NodeInstanceContainer;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;
import org.kie.kogito.jackson.utils.JsonObjectUtils;

public class JsonNodeContext
implements AutoCloseable {
    private final JsonNode jsonNode;
    private final Set<String> keys;

    public static JsonNodeContext from(JsonNode jsonNode, KogitoProcessContext context) {
        Map<Object, Object> map = Collections.emptyMap();
        if (jsonNode.isObject()) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            map = JsonNodeContext.addVariablesFromContext(context);
            map.forEach((arg_0, arg_1) -> ((ObjectNode)objectNode).set(arg_0, arg_1));
        }
        return new JsonNodeContext(jsonNode, map.keySet());
    }

    public JsonNode getNode() {
        return this.jsonNode;
    }

    private JsonNodeContext(JsonNode jsonNode, Set<String> keys) {
        this.jsonNode = jsonNode;
        this.keys = keys;
    }

    private static Map<String, JsonNode> addVariablesFromContext(KogitoProcessContext processInfo) {
        NodeInstanceContainer container;
        KogitoNodeInstance nodeInstance = processInfo.getNodeInstance();
        if (nodeInstance instanceof ContextableInstance) {
            return JsonNodeContext.getVariablesFromContext((ContextableInstance)nodeInstance);
        }
        if (nodeInstance != null && (container = nodeInstance.getNodeInstanceContainer()) instanceof ContextableInstance && container instanceof KogitoNodeInstance) {
            return JsonNodeContext.getVariablesFromContext((ContextableInstance)container);
        }
        return Collections.emptyMap();
    }

    private static boolean isEvalVariable(String varName, KogitoNodeInstance nodeInstance) {
        Node node = nodeInstance.getNode();
        VariableScope scope = (VariableScope)((ContextResolver)node).resolveContext("VariableScope", (Object)varName);
        return scope.getVariables().stream().filter(v -> v.getName().equals(varName)).findAny().orElseThrow().getMetaData("evalVariable") != null;
    }

    private static Map<String, JsonNode> getVariablesFromContext(ContextableInstance node) {
        VariableScopeInstance variableScope = (VariableScopeInstance)node.getContextInstance("VariableScope");
        return variableScope.getVariables().entrySet().stream().filter(e -> JsonNodeContext.isEvalVariable((String)e.getKey(), (KogitoNodeInstance)node)).collect(Collectors.toMap(Map.Entry::getKey, entry -> JsonObjectUtils.fromValue(entry.getValue())));
    }

    @Override
    public void close() {
        if (!this.keys.isEmpty()) {
            this.keys.forEach(arg_0 -> ((ObjectNode)((ObjectNode)this.jsonNode)).remove(arg_0));
        }
    }
}

