/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.functions.FunctionDefinition;
import java.util.ArrayList;
import java.util.function.Function;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;
import org.kie.kogito.jackson.utils.MergeUtils;
import org.kie.kogito.serverless.workflow.utils.ConfigResolverHolder;
import org.kie.kogito.serverless.workflow.utils.KogitoProcessContextResolver;

public class ExpressionHandlerUtils {
    private static final String EXPR_PREFIX = "${";
    private static final String EXPR_SUFFIX = "}";
    private static final String LEGACY_EXPR_PREFIX = "{{";
    private static final String LEGACY_EXPR_SUFFIX = "}}";
    private static final String FUNCTION_REFERENCE = "fn:";
    public static final String SECRET_MAGIC = "SECRET";
    public static final String CONST_MAGIC = "CONST";
    public static final String CONTEXT_MAGIC = "WORKFLOW";

    private ExpressionHandlerUtils() {
    }

    public static JsonNode getConstants(KogitoProcessContext context) {
        JsonNode node = (JsonNode)context.getProcessInstance().getProcess().getMetaData().get("Constants");
        return node == null ? NullNode.instance : node;
    }

    public static String getSecret(String key) {
        return ConfigResolverHolder.getConfigResolver().getConfigProperty(key, String.class).orElse(null);
    }

    public static Function<String, Object> getContextFunction(KogitoProcessContext context) {
        return k -> KogitoProcessContextResolver.get().readKey(context, (String)k);
    }

    public static String trimExpr(String expr) {
        if ((expr = expr.trim()).startsWith(EXPR_PREFIX)) {
            expr = ExpressionHandlerUtils.trimExpr(expr, EXPR_PREFIX, EXPR_SUFFIX);
        } else if (expr.startsWith(LEGACY_EXPR_PREFIX)) {
            expr = ExpressionHandlerUtils.trimExpr(expr, LEGACY_EXPR_PREFIX, LEGACY_EXPR_SUFFIX);
        }
        return expr.trim();
    }

    private static String trimExpr(String expr, String prefix, String suffix) {
        if ((expr = expr.substring(prefix.length())).endsWith(suffix)) {
            expr = expr.substring(0, expr.length() - suffix.length());
        }
        return expr;
    }

    public static String replaceExpr(Workflow workflow, String expr) {
        if (expr != null) {
            String candidate = ExpressionHandlerUtils.trimExpr(expr);
            if (candidate.startsWith(FUNCTION_REFERENCE)) {
                String functionName = candidate.substring(FUNCTION_REFERENCE.length());
                return ExpressionHandlerUtils.replaceExpr(workflow, workflow.getFunctions().getFunctionDefs().stream().filter(f -> f.getType() == FunctionDefinition.Type.EXPRESSION && f.getName().equals(functionName)).findAny().map(FunctionDefinition::getOperation).orElseThrow(() -> new IllegalArgumentException("Cannot find function " + functionName)));
            }
            return candidate;
        }
        return expr;
    }

    public static void assign(JsonNode context, JsonNode target, JsonNode value, String expr) {
        JsonNode merged = MergeUtils.merge((JsonNode)value, (JsonNode)target);
        if (context.isObject()) {
            ObjectNode root = (ObjectNode)context;
            StringBuilder sb = new StringBuilder();
            ArrayList<String> properties = new ArrayList<String>();
            for (int i = expr.length() - 1; i >= 0; --i) {
                char c = expr.charAt(i);
                if (Character.isJavaIdentifierPart(c)) {
                    sb.insert(0, expr.charAt(i));
                    continue;
                }
                if (c == '.') {
                    if (sb.length() == 0) break;
                    properties.add(0, sb.toString());
                    sb = new StringBuilder();
                    continue;
                }
                if (sb.length() <= 0) break;
                properties.add(0, sb.toString());
                break;
            }
            if (!properties.isEmpty()) {
                int size = properties.size() - 1;
                for (int i = 0; i < size; ++i) {
                    root = ExpressionHandlerUtils.addObjectNode(root, (String)properties.get(i));
                }
                root.set((String)properties.get(size), merged);
            }
        }
    }

    private static ObjectNode addObjectNode(ObjectNode target, String propName) {
        JsonNode childNode;
        if (target.has(propName) && (childNode = target.get(propName)).isObject()) {
            return (ObjectNode)childNode;
        }
        ObjectNode newNode = target.objectNode();
        target.set(propName, (JsonNode)newNode);
        return newNode;
    }
}

