/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.jobs.impl;

import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.kogito.jobs.JobDescription;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.jobs.ProcessInstanceJobDescription;
import org.kie.kogito.jobs.ProcessJobDescription;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.kie.services.time.TimerInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryJobService
implements JobsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InMemoryJobService.class);
    private static final String TRIGGER = "timer";
    protected final ScheduledThreadPoolExecutor scheduler;
    protected final ProcessRuntime processRuntime;
    protected final UnitOfWorkManager unitOfWorkManager;
    protected ConcurrentHashMap<String, ScheduledFuture<?>> scheduledJobs = new ConcurrentHashMap();

    public InMemoryJobService(ProcessRuntime processRuntime, UnitOfWorkManager unitOfWorkManager) {
        this(1, processRuntime, unitOfWorkManager);
    }

    public InMemoryJobService(int threadPoolSize, ProcessRuntime processRuntime, UnitOfWorkManager unitOfWorkManager) {
        this.scheduler = new ScheduledThreadPoolExecutor(threadPoolSize);
        this.processRuntime = processRuntime;
        this.unitOfWorkManager = unitOfWorkManager;
    }

    public String scheduleProcessJob(ProcessJobDescription description) {
        LOGGER.debug("ScheduleProcessJob: {}", (Object)description);
        ScheduledFuture<?> future = null;
        future = description.expirationTime().repeatInterval() != null ? this.scheduler.scheduleAtFixedRate(this.repeatableProcessJobByDescription(description), this.calculateDelay((JobDescription)description), description.expirationTime().repeatInterval(), TimeUnit.MILLISECONDS) : this.scheduler.schedule(this.processJobByDescription(description), this.calculateDelay((JobDescription)description), TimeUnit.MILLISECONDS);
        this.scheduledJobs.put(description.id(), future);
        return description.id();
    }

    public String scheduleProcessInstanceJob(ProcessInstanceJobDescription description) {
        ScheduledFuture<?> future = null;
        future = description.expirationTime().repeatInterval() != null ? this.scheduler.scheduleAtFixedRate(new SignalProcessInstanceOnExpiredTimer(description.id(), description.processInstanceId(), false, description.expirationTime().repeatLimit()), this.calculateDelay((JobDescription)description), description.expirationTime().repeatInterval(), TimeUnit.MILLISECONDS) : this.scheduler.schedule(new SignalProcessInstanceOnExpiredTimer(description.id(), description.processInstanceId(), true, -1), this.calculateDelay((JobDescription)description), TimeUnit.MILLISECONDS);
        this.scheduledJobs.put(description.id(), future);
        return description.id();
    }

    public boolean cancelJob(String id) {
        LOGGER.debug("Cancel Job: {}", (Object)id);
        if (this.scheduledJobs.containsKey(id)) {
            return this.scheduledJobs.remove(id).cancel(true);
        }
        return false;
    }

    public ZonedDateTime getScheduledTime(String id) {
        ScheduledFuture<?> scheduled;
        long remainingTime;
        if (this.scheduledJobs.containsKey(id) && (remainingTime = (scheduled = this.scheduledJobs.get(id)).getDelay(TimeUnit.MILLISECONDS)) > 0L) {
            return ZonedDateTime.from(Instant.ofEpochMilli(System.currentTimeMillis() + remainingTime));
        }
        return null;
    }

    protected long calculateDelay(JobDescription description) {
        return Duration.between(ZonedDateTime.now(), description.expirationTime().get()).toMillis();
    }

    protected Runnable processJobByDescription(ProcessJobDescription description) {
        if (description.process() != null) {
            return new StartProcessOnExpiredTimer(description.id(), description.process(), true, -1);
        }
        return new LegacyStartProcessOnExpiredTimer(description.id(), description.processId(), true, -1);
    }

    protected Runnable repeatableProcessJobByDescription(ProcessJobDescription description) {
        if (description.process() != null) {
            return new StartProcessOnExpiredTimer(description.id(), description.process(), false, description.expirationTime().repeatLimit());
        }
        return new LegacyStartProcessOnExpiredTimer(description.id(), description.processId(), false, description.expirationTime().repeatLimit());
    }

    private class LegacyStartProcessOnExpiredTimer
    implements Runnable {
        private final String id;
        private boolean removeAtExecution;
        private String processId;
        private Integer limit;

        private LegacyStartProcessOnExpiredTimer(String id, String processId, boolean removeAtExecution, Integer limit) {
            this.id = id;
            this.processId = processId;
            this.removeAtExecution = removeAtExecution;
            this.limit = limit;
        }

        @Override
        public void run() {
            try {
                LOGGER.debug("Job {} started", (Object)this.id);
                UnitOfWorkExecutor.executeInUnitOfWork(InMemoryJobService.this.unitOfWorkManager, () -> {
                    org.kie.api.runtime.process.ProcessInstance pi = InMemoryJobService.this.processRuntime.createProcessInstance(this.processId, null);
                    if (pi != null) {
                        InMemoryJobService.this.processRuntime.startProcessInstance(pi.getId(), InMemoryJobService.TRIGGER);
                    }
                    return null;
                });
                Integer n = this.limit;
                Integer n2 = this.limit = Integer.valueOf(this.limit - 1);
                if (this.limit == 0) {
                    InMemoryJobService.this.scheduledJobs.remove(this.id).cancel(false);
                }
                LOGGER.debug("Job {} completed", (Object)this.id);
            }
            finally {
                if (this.removeAtExecution) {
                    InMemoryJobService.this.scheduledJobs.remove(this.id);
                }
            }
        }
    }

    private class StartProcessOnExpiredTimer
    implements Runnable {
        private final String id;
        private boolean removeAtExecution;
        private Process process;
        private Integer limit;

        private StartProcessOnExpiredTimer(String id, Process<?> process, boolean removeAtExecution, Integer limit) {
            this.id = id;
            this.process = process;
            this.removeAtExecution = removeAtExecution;
            this.limit = limit;
        }

        @Override
        public void run() {
            try {
                LOGGER.debug("Job {} started", (Object)this.id);
                UnitOfWorkExecutor.executeInUnitOfWork(InMemoryJobService.this.unitOfWorkManager, () -> {
                    ProcessInstance pi = this.process.createInstance(this.process.createModel());
                    if (pi != null) {
                        pi.start(InMemoryJobService.TRIGGER, null);
                    }
                    return null;
                });
                Integer n = this.limit;
                Integer n2 = this.limit = Integer.valueOf(this.limit - 1);
                if (this.limit == 0) {
                    InMemoryJobService.this.scheduledJobs.remove(this.id).cancel(false);
                }
                LOGGER.debug("Job {} completed", (Object)this.id);
            }
            finally {
                if (this.removeAtExecution) {
                    InMemoryJobService.this.scheduledJobs.remove(this.id);
                }
            }
        }
    }

    private class SignalProcessInstanceOnExpiredTimer
    implements Runnable {
        private final String id;
        private boolean removeAtExecution;
        private String processInstanceId;
        private Integer limit;

        private SignalProcessInstanceOnExpiredTimer(String id, String processInstanceId, boolean removeAtExecution, Integer limit) {
            this.id = id;
            this.processInstanceId = processInstanceId;
            this.removeAtExecution = removeAtExecution;
            this.limit = limit;
        }

        @Override
        public void run() {
            try {
                LOGGER.debug("Job {} started", (Object)this.id);
                UnitOfWorkExecutor.executeInUnitOfWork(InMemoryJobService.this.unitOfWorkManager, () -> {
                    org.kie.api.runtime.process.ProcessInstance pi = InMemoryJobService.this.processRuntime.getProcessInstance(this.processInstanceId);
                    if (pi != null) {
                        String[] ids = this.id.split("_");
                        Integer n = this.limit;
                        Integer n2 = this.limit = Integer.valueOf(this.limit - 1);
                        pi.signalEvent("timerTriggered", (Object)TimerInstance.with(Long.valueOf(ids[1]), this.id, this.limit));
                        if (this.limit == 0) {
                            InMemoryJobService.this.scheduledJobs.remove(this.id).cancel(false);
                        }
                    } else {
                        InMemoryJobService.this.scheduledJobs.remove(this.id).cancel(false);
                    }
                    return null;
                });
                LOGGER.debug("Job {} completed", (Object)this.id);
            }
            finally {
                if (this.removeAtExecution) {
                    InMemoryJobService.this.scheduledJobs.remove(this.id);
                }
            }
        }
    }
}

