/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.uow;

import java.util.LinkedHashSet;
import java.util.Set;
import org.kie.kogito.uow.UnitOfWork;
import org.kie.kogito.uow.WorkUnit;

public class CollectingUnitOfWork
implements UnitOfWork {
    private Set<WorkUnit> collectedWork;
    private boolean done;

    public void start() {
        this.checkDone();
        if (this.collectedWork == null) {
            this.collectedWork = new LinkedHashSet<WorkUnit>();
        }
    }

    public void end() {
        this.checkStarted();
        this.collectedWork.forEach(work -> work.perform());
        this.done();
    }

    public void abort() {
        this.checkStarted();
        this.collectedWork.forEach(work -> work.abort());
        this.done();
    }

    public void intercept(WorkUnit work) {
        this.checkStarted();
        if (work == null) {
            throw new NullPointerException("Work must be non null");
        }
        this.collectedWork.add(work);
    }

    protected void checkDone() {
        if (this.done) {
            throw new IllegalStateException("Unit of work is already done (ended or aborted)");
        }
    }

    protected void checkStarted() {
        if (this.collectedWork == null) {
            throw new IllegalStateException("Unit of work is not started");
        }
    }

    protected void done() {
        this.done = true;
        this.collectedWork = null;
    }
}

