/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.signal;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.kie.kogito.signal.SignalManager;
import org.kie.kogito.signal.SignalManagerHub;

public class DefaultSignalManagerHub
implements SignalManagerHub {
    private ConcurrentHashMap<String, List<SignalManager>> signalManagers = new ConcurrentHashMap();

    public void publish(String type, Object signalData) {
        this.signalManagers.getOrDefault(type, Collections.emptyList()).forEach(e -> e.signalEvent(type, signalData));
    }

    public void publishTargeting(long id, String type, Object signalData) {
        this.signalManagers.getOrDefault(type, Collections.emptyList()).forEach(e -> e.signalEvent(id, type, signalData));
    }

    public void subscribe(String type, SignalManager signalManager) {
        this.signalManagers.compute(type, (k, v) -> {
            if (v == null) {
                v = new CopyOnWriteArrayList<SignalManager>();
            }
            v.add(signalManager);
            return v;
        });
    }

    public void unsubscribe(String type, SignalManager signalManager) {
        this.signalManagers.computeIfPresent(type, (k, v) -> {
            v.remove(signalManager);
            if (v.isEmpty()) {
                this.signalManagers.remove(type);
            }
            return v;
        });
    }
}

