/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.signal;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.kie.api.runtime.process.EventListener;
import org.kie.kogito.signal.SignalManager;
import org.kie.kogito.signal.SignalManagerHub;
import org.kie.services.signal.EventListenerResolver;

public class LightSignalManager
implements SignalManager {
    private SignalManagerHub signalManagerHub;
    private final EventListenerResolver instanceResolver;
    private ConcurrentHashMap<String, List<EventListener>> listeners = new ConcurrentHashMap();

    public LightSignalManager(EventListenerResolver instanceResolver, SignalManagerHub signalManagerHub) {
        this.instanceResolver = instanceResolver;
        this.signalManagerHub = signalManagerHub;
    }

    public void addEventListener(String type, EventListener eventListener) {
        this.listeners.compute(type, (k, v) -> {
            if (v == null) {
                v = new CopyOnWriteArrayList<EventListener>();
            }
            v.add(eventListener);
            return v;
        });
        this.signalManagerHub.subscribe(type, (SignalManager)this);
    }

    public void removeEventListener(String type, EventListener eventListener) {
        this.listeners.computeIfPresent(type, (k, v) -> {
            v.remove(eventListener);
            if (v.isEmpty()) {
                this.listeners.remove(type);
            }
            return v;
        });
        this.signalManagerHub.unsubscribe(type, (SignalManager)this);
    }

    public void signalEvent(String type, Object event) {
        if (!this.listeners.containsKey(type)) {
            this.signalManagerHub.publish(type, event);
        }
        this.listeners.getOrDefault(type, Collections.emptyList()).forEach(e -> e.signalEvent(type, event));
    }

    public void signalEvent(long processInstanceId, String type, Object event) {
        this.instanceResolver.find(processInstanceId).ifPresent(signalable -> signalable.signalEvent(type, event));
    }
}

