/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.event;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.UUID;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.services.event.impl.UserTaskInstanceEventBody;

public class UserTaskInstanceDataEvent
implements DataEvent<UserTaskInstanceEventBody> {
    private final String specversion;
    private final String id = UUID.randomUUID().toString();
    private final String source;
    private final String type;
    private final String time;
    private final UserTaskInstanceEventBody data;
    private final String kogitoUserTaskinstanceId;
    private final String kogitoProcessinstanceId;
    private final String kogitoRootProcessinstanceId;
    private final String kogitoProcessId;
    private final String kogitoRootProcessId;
    private final String kogitoUserTaskinstanceState;

    public UserTaskInstanceDataEvent(String source, Map<String, String> metaData, UserTaskInstanceEventBody body) {
        this.specversion = "0.3";
        this.source = source;
        this.type = "UserTaskInstanceEvent";
        this.time = ZonedDateTime.now().format(DateTimeFormatter.ISO_ZONED_DATE_TIME);
        this.data = body;
        this.kogitoProcessinstanceId = metaData.get("kogito.processinstance.id");
        this.kogitoRootProcessinstanceId = metaData.get("kogito.processinstance.rootInstanceId");
        this.kogitoProcessId = metaData.get("kogito.processinstance.processId");
        this.kogitoRootProcessId = metaData.get("kogito.processinstance.rootProcessId");
        this.kogitoUserTaskinstanceState = metaData.get("kogito.usertaskinstance.state");
        this.kogitoUserTaskinstanceId = metaData.get("kogito.usertaskinstance.id");
    }

    public String getSource() {
        return this.source;
    }

    public UserTaskInstanceEventBody getData() {
        return this.data;
    }

    public String getSpecversion() {
        return this.specversion;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getTime() {
        return this.time;
    }

    public String getKogitoProcessinstanceId() {
        return this.kogitoProcessinstanceId;
    }

    public String getKogitoRootProcessinstanceId() {
        return this.kogitoRootProcessinstanceId;
    }

    public String getKogitoProcessId() {
        return this.kogitoProcessId;
    }

    public String getKogitoRootProcessId() {
        return this.kogitoRootProcessId;
    }

    public String getKogitoUserTaskinstanceId() {
        return this.kogitoUserTaskinstanceId;
    }

    public String getKogitoUserTaskinstanceState() {
        return this.kogitoUserTaskinstanceState;
    }
}

