/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.time.manager;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.services.time.Job;
import org.kie.services.time.JobContext;
import org.kie.services.time.JobHandle;
import org.kie.services.time.TimerService;
import org.kie.services.time.Trigger;
import org.kie.services.time.impl.CronTrigger;
import org.kie.services.time.impl.IntervalTrigger;
import org.kie.services.time.manager.TimerInstance;
import org.kie.services.time.manager.TimerManagerRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerManager {
    private static final Logger logger = LoggerFactory.getLogger(TimerManager.class);
    private long timerId = 0L;
    private TimerManagerRuntime runtime;
    private TimerService timerService;
    private Map<Long, TimerInstance> timers = new ConcurrentHashMap<Long, TimerInstance>();
    public static final Job processJob = new ProcessJob();
    public static final Job startProcessJob = new StartProcessJob();

    public TimerManager(TimerManagerRuntime runtime, TimerService timerService) {
        this.runtime = runtime;
        this.timerService = timerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTimer(TimerInstance timer, ProcessInstance processInstance) {
        try {
            this.runtime.startOperation();
            timer.setId(++this.timerId);
            timer.setProcessInstanceId(processInstance.getId());
            timer.setSessionId(this.runtime.getIdentifier());
            timer.setActivated(new Date());
            Trigger trigger = null;
            if (timer.getCronExpression() != null) {
                Date startTime = new Date(this.timerService.getCurrentTime() + 1000L);
                trigger = new CronTrigger(this.timerService.getCurrentTime(), startTime, null, -1, timer.getCronExpression(), null, null);
                timer.setPeriod(1L);
            } else {
                trigger = new IntervalTrigger(this.timerService.getCurrentTime(), null, null, timer.getRepeatLimit(), timer.getDelay(), timer.getPeriod(), null, null);
            }
            ProcessJobContext ctx = new ProcessJobContext(timer, trigger, processInstance.getId(), this.runtime);
            JobHandle jobHandle = this.timerService.scheduleJob(processJob, ctx, trigger);
            timer.setJobHandle(jobHandle);
            this.timers.put(timer.getId(), timer);
        }
        finally {
            this.runtime.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTimer(TimerInstance timer, String processId, Map<String, Object> params) {
        try {
            this.runtime.startOperation();
            timer.setId(++this.timerId);
            timer.setProcessInstanceId(null);
            timer.setSessionId(this.runtime.getIdentifier());
            timer.setActivated(new Date());
            Trigger trigger = null;
            if (timer.getCronExpression() != null) {
                Date startTime = new Date(this.timerService.getCurrentTime() + 1000L);
                trigger = new CronTrigger(this.timerService.getCurrentTime(), startTime, null, -1, timer.getCronExpression(), null, null);
                timer.setPeriod(1L);
            } else {
                trigger = new IntervalTrigger(this.timerService.getCurrentTime(), null, null, timer.getRepeatLimit(), timer.getDelay(), timer.getPeriod(), null, null);
            }
            StartProcessJobContext ctx = new StartProcessJobContext(timer, trigger, processId, params, this.runtime);
            JobHandle jobHandle = this.timerService.scheduleJob(startProcessJob, ctx, trigger);
            timer.setJobHandle(jobHandle);
            this.timers.put(timer.getId(), timer);
        }
        finally {
            this.runtime.endOperation();
        }
    }

    public void internalAddTimer(TimerInstance timer) {
        long delay;
        Date lastTriggered = timer.getLastTriggered();
        if (lastTriggered == null) {
            Date activated = timer.getActivated();
            Date now = new Date();
            long timespan = now.getTime() - activated.getTime();
            delay = timer.getDelay() - timespan;
            if (delay < 0L) {
                delay = 0L;
            }
        } else {
            Date now = new Date();
            long timespan = now.getTime() - lastTriggered.getTime();
            delay = timespan - timer.getPeriod();
            if (delay < 0L) {
                delay = 0L;
            }
        }
        IntervalTrigger trigger = new IntervalTrigger(this.timerService.getCurrentTime(), null, null, -1, delay, timer.getPeriod(), null, null);
        ProcessJobContext ctx = new ProcessJobContext(timer, trigger, timer.getProcessInstanceId(), this.runtime);
        JobHandle jobHandle = this.timerService.scheduleJob(processJob, ctx, trigger);
        timer.setJobHandle(jobHandle);
        this.timers.put(timer.getId(), timer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTimer(long timerId) {
        try {
            this.runtime.startOperation();
            TimerInstance timer = this.timers.remove(timerId);
            if (timer != null) {
                this.timerService.removeJob(timer.getJobHandle());
            }
        }
        finally {
            this.runtime.endOperation();
        }
    }

    public void dispose() {
        Iterator<TimerInstance> it = this.timers.values().iterator();
        while (it.hasNext()) {
            TimerInstance timer = it.next();
            this.timerService.removeJob(timer.getJobHandle());
            it.remove();
        }
        this.timerService.shutdown();
    }

    public TimerService getTimerService() {
        return this.timerService;
    }

    public Collection<TimerInstance> getTimers() {
        return this.timers.values();
    }

    public Map<Long, TimerInstance> getTimerMap() {
        return this.timers;
    }

    public long internalGetTimerId() {
        return this.timerId;
    }

    public void internalSetTimerId(long timerId) {
        this.timerId = timerId;
    }

    public void setTimerService(TimerService timerService) {
        this.timerService = timerService;
    }

    public static class OverdueTrigger
    implements Trigger {
        private static final long serialVersionUID = -2368476147776308013L;
        public static final long OVERDUE_DELAY = Long.parseLong(System.getProperty("jbpm.overdue.timer.delay", "2000"));
        private Trigger orig;
        private TimerManagerRuntime runtime;

        public OverdueTrigger(Trigger orig, TimerManagerRuntime runtime) {
            this.orig = orig;
            this.runtime = runtime;
        }

        @Override
        public Date hasNextFireTime() {
            long now;
            Date date = this.orig.hasNextFireTime();
            if (date == null) {
                return null;
            }
            long then = date.getTime();
            if (then < (now = this.runtime.getSessionClock().getCurrentTime())) {
                return new Date(now + OVERDUE_DELAY);
            }
            return this.orig.hasNextFireTime();
        }

        @Override
        public Date nextFireTime() {
            return this.orig.nextFireTime();
        }
    }

    public static class StartProcessJobContext
    extends ProcessJobContext {
        private static final long serialVersionUID = -5219141659893424294L;
        private String processId;
        private Map<String, Object> paramaeters;

        public StartProcessJobContext(TimerInstance timer, Trigger trigger, String processId, Map<String, Object> params, TimerManagerRuntime runtime) {
            super(timer, trigger, null, runtime);
            this.processId = processId;
            this.paramaeters = params;
        }

        public String getProcessId() {
            return this.processId;
        }

        public void setProcessId(String processId) {
            this.processId = processId;
        }

        public Map<String, Object> getParamaeters() {
            return this.paramaeters;
        }

        public void setParamaeters(Map<String, Object> paramaeters) {
            this.paramaeters = paramaeters;
        }

        @Override
        public boolean isNewTimer() {
            return false;
        }
    }

    public static class ProcessJobContext
    implements JobContext {
        private static final long serialVersionUID = 476843895176221627L;
        private String processInstanceId;
        private transient TimerManagerRuntime runtime;
        private TimerInstance timer;
        private Trigger trigger;
        private JobHandle jobHandle;
        private Long sessionId;
        private boolean newTimer;

        public ProcessJobContext(TimerInstance timer, Trigger trigger, String processInstanceId, TimerManagerRuntime runtime) {
            this.timer = timer;
            this.trigger = trigger;
            this.processInstanceId = processInstanceId;
            this.runtime = runtime;
            this.sessionId = timer.getSessionId();
            this.newTimer = true;
        }

        public ProcessJobContext(TimerInstance timer, Trigger trigger, String processInstanceId, TimerManagerRuntime runtime, boolean newTimer) {
            this.timer = timer;
            this.trigger = trigger;
            this.processInstanceId = processInstanceId;
            this.runtime = runtime;
            this.sessionId = timer.getSessionId();
            this.newTimer = newTimer;
        }

        public String getProcessInstanceId() {
            return this.processInstanceId;
        }

        public TimerManagerRuntime getKnowledgeRuntime() {
            return this.runtime;
        }

        public Trigger getTrigger() {
            return this.trigger;
        }

        @Override
        public JobHandle getJobHandle() {
            return this.jobHandle;
        }

        @Override
        public void setJobHandle(JobHandle jobHandle) {
            this.jobHandle = jobHandle;
        }

        public TimerInstance getTimer() {
            return this.timer;
        }

        public Long getSessionId() {
            return this.sessionId;
        }

        public void setKnowledgeRuntime(TimerManagerRuntime runtime) {
            this.runtime = runtime;
        }

        public boolean isNewTimer() {
            return this.newTimer;
        }
    }

    public static class StartProcessJob
    implements Job,
    Serializable {
        private static final long serialVersionUID = 1039445333595469160L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(JobContext c) {
            StartProcessJobContext ctx = (StartProcessJobContext)c;
            TimerManagerRuntime runtime = ctx.getKnowledgeRuntime();
            TimerManager tm = runtime.getTimerManager();
            if (!runtime.isActive()) {
                logger.debug("Timer for starting process {} is ignored as the deployment is in deactivated state", (Object)ctx.getProcessId());
                tm.getTimerMap().remove(ctx.getTimer().getId());
                tm.getTimerService().removeJob(ctx.getJobHandle());
                return;
            }
            try {
                runtime.startOperation();
                ctx.getTimer().setLastTriggered(new Date(ctx.getKnowledgeRuntime().getSessionClock().getCurrentTime()));
                if (ctx.getTrigger().hasNextFireTime() == null) {
                    ctx.getTimer().setPeriod(0L);
                }
                runtime.startProcess(ctx.getProcessId(), ctx.getParamaeters(), "timer");
                if (ctx.getTimer().getPeriod() == 0L) {
                    tm.getTimerMap().remove(ctx.getTimer().getId());
                    tm.getTimerService().removeJob(ctx.getJobHandle());
                }
            }
            catch (Throwable e) {
                logger.error("Error when executing start process " + ctx.getProcessId() + " timer job", e);
            }
            finally {
                runtime.endOperation();
            }
        }
    }

    public static class ProcessJob
    implements Job,
    Serializable {
        private static final long serialVersionUID = 6004839244692770390L;

        @Override
        public void execute(JobContext c) {
            ProcessJobContext ctx = (ProcessJobContext)c;
            String processInstanceId = ctx.getProcessInstanceId();
            TimerManagerRuntime runtime = ctx.getKnowledgeRuntime();
            try {
                runtime.startOperation();
                if (processInstanceId == null) {
                    throw new IllegalArgumentException("Could not find process instance for timer ");
                }
                ctx.getTimer().setLastTriggered(new Date());
                if (ctx.getTrigger().hasNextFireTime() == null) {
                    ctx.getTimer().setPeriod(0L);
                }
                runtime.getSignalManager().signalEvent(processInstanceId, "timerTriggered", (Object)ctx.getTimer());
                TimerManager tm = runtime.getTimerManager();
                if (ctx.getTimer().getPeriod() == 0L) {
                    tm.getTimerMap().remove(ctx.getTimer().getId());
                    tm.getTimerService().removeJob(ctx.getJobHandle());
                }
            }
            catch (Throwable e) {
                logger.error("Error when executing timer job", e);
                throw new RuntimeException(e);
            }
            finally {
                runtime.endOperation();
            }
        }
    }
}

