/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.jobs.impl;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.kogito.jobs.JobDescription;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.jobs.ProcessInstanceJobDescription;
import org.kie.kogito.jobs.ProcessJobDescription;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.kie.services.time.TimerInstance;

public class InMemoryJobService
implements JobsService {
    protected final ScheduledThreadPoolExecutor scheduler;
    protected final ProcessRuntime processRuntime;
    protected final UnitOfWorkManager unitOfWorkManager;
    protected ConcurrentHashMap<String, ScheduledFuture<?>> scheduledJobs = new ConcurrentHashMap();

    public InMemoryJobService(ProcessRuntime processRuntime, UnitOfWorkManager unitOfWorkManager) {
        this.scheduler = new ScheduledThreadPoolExecutor(1);
        this.processRuntime = processRuntime;
        this.unitOfWorkManager = unitOfWorkManager;
    }

    public InMemoryJobService(int threadPoolSize, ProcessRuntime processRuntime, UnitOfWorkManager unitOfWorkManager) {
        this.scheduler = new ScheduledThreadPoolExecutor(threadPoolSize);
        this.processRuntime = processRuntime;
        this.unitOfWorkManager = unitOfWorkManager;
    }

    public String scheduleProcessJob(ProcessJobDescription description) {
        ScheduledFuture<?> future = null;
        future = description.expirationTime().repeatInterval() != null ? this.scheduler.scheduleAtFixedRate(new StartProcessOnExpiredTimer(description.id(), description.processId(), false, description.expirationTime().repeatLimit()), this.calculateDelay((JobDescription)description), description.expirationTime().repeatInterval(), TimeUnit.MILLISECONDS) : this.scheduler.schedule(new StartProcessOnExpiredTimer(description.id(), description.processId(), true, -1), this.calculateDelay((JobDescription)description), TimeUnit.MILLISECONDS);
        this.scheduledJobs.put(description.id(), future);
        return description.id();
    }

    public String scheduleProcessInstanceJob(ProcessInstanceJobDescription description) {
        ScheduledFuture<?> future = null;
        future = description.expirationTime().repeatInterval() != null ? this.scheduler.scheduleAtFixedRate(new SignalProcessInstanceOnExpiredTimer(description.id(), description.processInstanceId(), false, description.expirationTime().repeatLimit()), this.calculateDelay((JobDescription)description), description.expirationTime().repeatInterval(), TimeUnit.MILLISECONDS) : this.scheduler.schedule(new SignalProcessInstanceOnExpiredTimer(description.id(), description.processInstanceId(), true, -1), this.calculateDelay((JobDescription)description), TimeUnit.MILLISECONDS);
        this.scheduledJobs.put(description.id(), future);
        return description.id();
    }

    public boolean cancelJob(String id) {
        if (this.scheduledJobs.containsKey(id)) {
            return this.scheduledJobs.remove(id).cancel(true);
        }
        return false;
    }

    protected long calculateDelay(JobDescription description) {
        return Duration.between(ZonedDateTime.now(), description.expirationTime().get()).toMillis();
    }

    private class StartProcessOnExpiredTimer
    implements Runnable {
        private final String id;
        private boolean removeAtExecution;
        private String processId;
        private Integer limit;

        private StartProcessOnExpiredTimer(String id, String processId, boolean removeAtExecution, Integer limit) {
            this.id = id;
            this.processId = processId;
            this.removeAtExecution = removeAtExecution;
            this.limit = limit;
        }

        @Override
        public void run() {
            try {
                UnitOfWorkExecutor.executeInUnitOfWork(InMemoryJobService.this.unitOfWorkManager, () -> {
                    ProcessInstance pi = InMemoryJobService.this.processRuntime.createProcessInstance(this.processId, null);
                    if (pi != null) {
                        InMemoryJobService.this.processRuntime.startProcessInstance(pi.getId(), "timer");
                    }
                    return null;
                });
                Integer n = this.limit;
                Integer n2 = this.limit = Integer.valueOf(this.limit - 1);
                if (this.limit == 0) {
                    InMemoryJobService.this.scheduledJobs.remove(this.id).cancel(false);
                }
            }
            finally {
                if (this.removeAtExecution) {
                    InMemoryJobService.this.scheduledJobs.remove(this.id);
                }
            }
        }
    }

    private class SignalProcessInstanceOnExpiredTimer
    implements Runnable {
        private final String id;
        private boolean removeAtExecution;
        private String processInstanceId;
        private Integer limit;

        private SignalProcessInstanceOnExpiredTimer(String id, String processInstanceId, boolean removeAtExecution, Integer limit) {
            this.id = id;
            this.processInstanceId = processInstanceId;
            this.removeAtExecution = removeAtExecution;
            this.limit = limit;
        }

        @Override
        public void run() {
            try {
                UnitOfWorkExecutor.executeInUnitOfWork(InMemoryJobService.this.unitOfWorkManager, () -> {
                    ProcessInstance pi = InMemoryJobService.this.processRuntime.getProcessInstance(this.processInstanceId);
                    if (pi != null) {
                        String[] ids = this.id.split("_");
                        Integer n = this.limit;
                        Integer n2 = this.limit = Integer.valueOf(this.limit - 1);
                        pi.signalEvent("timerTriggered", (Object)TimerInstance.with(Long.valueOf(ids[1]), this.id, this.limit));
                        if (this.limit == 0) {
                            InMemoryJobService.this.scheduledJobs.remove(this.id).cancel(false);
                        }
                    } else {
                        InMemoryJobService.this.scheduledJobs.remove(this.id).cancel(false);
                    }
                    return null;
                });
            }
            finally {
                if (this.removeAtExecution) {
                    InMemoryJobService.this.scheduledJobs.remove(this.id);
                }
            }
        }
    }
}

