/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.event.impl;

import java.util.Optional;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.kogito.services.event.AbstractProcessDataEvent;
import org.kie.kogito.services.event.CloudEventEmitter;
import org.kie.kogito.services.event.EventMarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageProducer<D, T extends AbstractProcessDataEvent<D>> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMessageProducer.class);
    private Optional<Boolean> useCloudEvents;
    private EventMarshaller marshaller;
    private String trigger;
    private CloudEventEmitter emitter;

    public AbstractMessageProducer() {
    }

    public AbstractMessageProducer(CloudEventEmitter emitter, EventMarshaller marshaller, String trigger, Optional<Boolean> useCloudEvents) {
        this.emitter = emitter;
        this.marshaller = marshaller;
        this.trigger = trigger;
        this.useCloudEvents = useCloudEvents;
    }

    protected void setParams(CloudEventEmitter emitter, EventMarshaller marshaller, String trigger, Optional<Boolean> useCloudEvents) {
        this.emitter = emitter;
        this.marshaller = marshaller;
        this.trigger = trigger;
        this.useCloudEvents = useCloudEvents;
    }

    public void produce(ProcessInstance pi, D eventData) {
        this.emitter.emit(this.marshall(pi, eventData)).exceptionally(ex -> {
            logger.error("An error was caught while process " + pi.getProcessId() + " produced message " + eventData, ex);
            return null;
        });
    }

    protected String marshall(ProcessInstance pi, D eventData) {
        return this.marshaller.marshall(eventData, e -> this.dataEventTypeConstructor(e, pi, this.trigger), this.useCloudEvents);
    }

    protected abstract T dataEventTypeConstructor(D var1, ProcessInstance var2, String var3);
}

