/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.event.impl;

import java.util.Optional;
import org.kie.kogito.event.EventEmitter;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.services.event.AbstractProcessDataEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageProducer<D, T extends AbstractProcessDataEvent<D>> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMessageProducer.class);
    private String trigger;
    private EventEmitter emitter;

    public AbstractMessageProducer() {
    }

    public AbstractMessageProducer(EventEmitter emitter, String trigger) {
        this.setParams(emitter, trigger);
    }

    protected void setParams(EventEmitter emitter, String trigger) {
        this.emitter = emitter;
        this.trigger = trigger;
    }

    public void produce(KogitoProcessInstance pi, D eventData) {
        this.emitter.emit(eventData, this.trigger, Optional.of(e -> this.dataEventTypeConstructor(e, pi, this.trigger))).exceptionally(ex -> {
            logger.error("An error was caught while process " + pi.getProcessId() + " produced message " + eventData, ex);
            return null;
        });
    }

    protected abstract T dataEventTypeConstructor(D var1, KogitoProcessInstance var2, String var3);
}

