/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.event.correlation;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.kie.kogito.correlation.CompositeCorrelation;
import org.kie.kogito.correlation.CorrelationResolver;
import org.kie.kogito.services.event.correlation.SimpleAttributeCorrelationResolver;

public class CompositeAttributeCorrelationResolver
implements CorrelationResolver {
    private Map<String, CorrelationResolver> attributes;

    public CompositeAttributeCorrelationResolver(Set<String> attributeNames) {
        Objects.requireNonNull(attributeNames, "attributeNames should not be null");
        this.attributes = attributeNames.stream().collect(Collectors.toMap(name -> name, SimpleAttributeCorrelationResolver::new));
    }

    public CompositeCorrelation resolve(Object data) {
        Set correlations = this.attributes.entrySet().stream().map(e -> ((CorrelationResolver)e.getValue()).resolve(data)).collect(Collectors.toSet());
        return new CompositeCorrelation(correlations);
    }
}

