/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.event.correlation;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.kogito.correlation.Correlation;
import org.kie.kogito.correlation.CorrelationEncoder;
import org.kie.kogito.correlation.CorrelationInstance;
import org.kie.kogito.correlation.CorrelationService;
import org.kie.kogito.services.event.correlation.MD5CorrelationEncoder;

public class DefaultCorrelationService
implements CorrelationService {
    private static final Map<String, CorrelationInstance> correlationRepository = new ConcurrentHashMap<String, CorrelationInstance>();
    private static final Map<String, CorrelationInstance> correlatedRepository = new ConcurrentHashMap<String, CorrelationInstance>();
    private CorrelationEncoder correlationEncoder = new MD5CorrelationEncoder();

    public CorrelationInstance create(Correlation correlation, String correlatedId) {
        String encodedCorrelationId = this.correlationEncoder.encode(correlation);
        CorrelationInstance correlationInstance = new CorrelationInstance(encodedCorrelationId, correlatedId, correlation);
        correlationRepository.put(encodedCorrelationId, correlationInstance);
        correlatedRepository.put(correlatedId, correlationInstance);
        return correlationInstance;
    }

    public Optional<CorrelationInstance> find(Correlation correlation) {
        return Optional.ofNullable(correlationRepository.get(this.correlationEncoder.encode(correlation)));
    }

    public Optional<CorrelationInstance> findByCorrelatedId(String correlatedId) {
        return Optional.ofNullable(correlatedRepository.get(correlatedId));
    }

    public void delete(Correlation correlation) {
        CorrelationInstance removed = correlationRepository.remove(this.correlationEncoder.encode(correlation));
        correlatedRepository.remove(removed.getCorrelatedId());
    }

    public final void clear() {
        correlationRepository.clear();
        correlatedRepository.clear();
    }
}

