/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.event.correlation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import java.util.Optional;
import org.kie.kogito.correlation.Correlation;
import org.kie.kogito.correlation.CorrelationResolver;
import org.kie.kogito.correlation.SimpleCorrelation;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;

public class SimpleAttributeCorrelationResolver
implements CorrelationResolver {
    private String referenceKey;
    private ObjectMapper objectMapper = ObjectMapperFactory.get();
    private Optional<Class<?>> type;

    public SimpleAttributeCorrelationResolver(String referenceKey) {
        this(referenceKey, null);
    }

    public SimpleAttributeCorrelationResolver(String referenceKey, Class<?> type) {
        this.referenceKey = Objects.requireNonNull(referenceKey, "referenceKey should not be null");
        this.type = Optional.ofNullable(type);
    }

    public Correlation<?> resolve(Object data) {
        JsonNode jsonNode = this.objectMapper.valueToTree(data);
        JsonNode correlationValue = Optional.ofNullable(jsonNode.get(this.referenceKey)).orElseGet(() -> Optional.ofNullable(jsonNode.get("extensionattributes")).map(node -> node.get(this.referenceKey)).orElse(null));
        if (correlationValue == null) {
            return new SimpleCorrelation(this.referenceKey, null);
        }
        if (correlationValue.isTextual()) {
            return new SimpleCorrelation(this.referenceKey, (Object)correlationValue.textValue());
        }
        return (Correlation)this.type.map(t -> this.objectMapper.convertValue((Object)correlationValue, t)).map(v -> new SimpleCorrelation(this.referenceKey, v)).orElse(new SimpleCorrelation(this.referenceKey, (Object)correlationValue));
    }

    public static SimpleAttributeCorrelationResolver forAttribute(String attributeName) {
        return new SimpleAttributeCorrelationResolver(attributeName);
    }
}

