/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.event.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.kie.kogito.correlation.CompositeCorrelation;
import org.kie.kogito.event.EventEmitter;
import org.kie.kogito.event.process.ProcessDataEvent;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageProducer<D> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMessageProducer.class);
    private String trigger;
    private EventEmitter emitter;

    public AbstractMessageProducer() {
    }

    public AbstractMessageProducer(EventEmitter emitter, String trigger) {
        this.setParams(emitter, trigger);
    }

    protected void setParams(EventEmitter emitter, String trigger) {
        this.emitter = emitter;
        this.trigger = trigger;
    }

    public void produce(KogitoProcessInstance pi, D eventData) {
        this.emitter.emit(eventData, this.trigger, Optional.of(e -> this.dataEventTypeConstructor(e, pi, this.trigger))).exceptionally(ex -> {
            logger.error("An error was caught while process " + pi.getProcessId() + " produced message " + eventData, ex);
            return null;
        });
    }

    public ProcessDataEvent<D> dataEventTypeConstructor(D eventPayload, KogitoProcessInstance pi, String trigger) {
        ProcessDataEvent event = new ProcessDataEvent(trigger, "", eventPayload, pi.getStringId(), pi.getProcess().getVersion(), pi.getParentProcessInstanceId(), pi.getRootProcessInstanceId(), pi.getProcessId(), pi.getRootProcessId(), String.valueOf(pi.getState()), null, pi.getProcess().getType(), pi.getReferenceId());
        pi.unwrap().correlation().stream().map(c -> CompositeCorrelation.class.isInstance(c) ? ((CompositeCorrelation)CompositeCorrelation.class.cast(c)).getValue() : Collections.singleton(c)).flatMap(Collection::stream).forEach(c -> event.addExtensionAttribute(c.getKey(), c.getValue()));
        return event;
    }
}

