/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.event.impl;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Objects;
import org.kie.kogito.event.EventUnmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEventUnmarshaller
implements EventUnmarshaller<Object> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEventUnmarshaller.class);
    private final ObjectMapper objectMapper;

    public DefaultEventUnmarshaller(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public <T> T unmarshall(Object value, Class<T> clazz, Class<?> ... parametrizedClasses) throws IOException {
        JavaType type;
        logger.debug("Converting event with payload {} to class {} ", value, clazz);
        if (clazz.isInstance(value)) {
            return clazz.cast(value);
        }
        JavaType javaType = type = Objects.isNull(parametrizedClasses) ? this.objectMapper.getTypeFactory().constructType(clazz) : this.objectMapper.getTypeFactory().constructParametricType(clazz, (Class[])parametrizedClasses);
        if (value instanceof byte[]) {
            return (T)this.objectMapper.readValue((byte[])value, type);
        }
        return (T)this.objectMapper.readValue(value.toString(), type);
    }
}

