/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.event.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEvent;
import org.kie.api.event.process.ProcessNodeEvent;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.kogito.Addons;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.EventBatch;
import org.kie.kogito.event.process.AttachmentEventBody;
import org.kie.kogito.event.process.CommentEventBody;
import org.kie.kogito.event.process.MilestoneEventBody;
import org.kie.kogito.event.process.NodeInstanceEventBody;
import org.kie.kogito.event.process.ProcessErrorEventBody;
import org.kie.kogito.event.process.ProcessInstanceDataEvent;
import org.kie.kogito.event.process.ProcessInstanceEventBody;
import org.kie.kogito.event.process.UserTaskDeadlineDataEvent;
import org.kie.kogito.event.process.UserTaskDeadlineEventBody;
import org.kie.kogito.event.process.UserTaskInstanceDataEvent;
import org.kie.kogito.event.process.UserTaskInstanceEventBody;
import org.kie.kogito.event.process.VariableInstanceDataEvent;
import org.kie.kogito.event.process.VariableInstanceEventBody;
import org.kie.kogito.internal.process.event.HumanTaskDeadlineEvent;
import org.kie.kogito.internal.process.event.KogitoProcessVariableChangedEvent;
import org.kie.kogito.internal.process.event.ProcessWorkItemTransitionEvent;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkflowProcessInstance;
import org.kie.kogito.process.workitem.Attachment;
import org.kie.kogito.process.workitem.Comment;
import org.kie.kogito.process.workitem.HumanTaskWorkItem;

public class ProcessInstanceEventBatch
implements EventBatch {
    private final String service;
    private Addons addons;
    private List<ProcessEvent> rawEvents = new ArrayList<ProcessEvent>();

    public ProcessInstanceEventBatch(String service, Addons addons) {
        this.service = service;
        this.addons = addons;
    }

    public void append(Object rawEvent) {
        if (rawEvent instanceof ProcessEvent) {
            this.rawEvents.add((ProcessEvent)rawEvent);
        }
    }

    public Collection<DataEvent<?>> events() {
        LinkedHashMap<String, ProcessInstanceEventBody> processInstances = new LinkedHashMap<String, ProcessInstanceEventBody>();
        LinkedHashMap<String, UserTaskInstanceEventBody> userTaskInstances = new LinkedHashMap<String, UserTaskInstanceEventBody>();
        LinkedHashSet<VariableInstanceEventBody> variables = new LinkedHashSet<VariableInstanceEventBody>();
        ArrayList processedEvents = new ArrayList();
        for (ProcessEvent event : this.rawEvents) {
            ProcessInstanceEventBody body = processInstances.computeIfAbsent(((KogitoProcessInstance)event.getProcessInstance()).getStringId(), key -> this.create(event));
            if (event instanceof ProcessNodeTriggeredEvent) {
                this.handleProcessNodeTriggeredEvent((ProcessNodeTriggeredEvent)event, body);
                continue;
            }
            if (event instanceof ProcessNodeLeftEvent) {
                this.handleProcessNodeLeftEvent((ProcessNodeLeftEvent)event, body);
                continue;
            }
            if (event instanceof ProcessCompletedEvent) {
                this.handleProcessCompletedEvent((ProcessCompletedEvent)event, body);
                continue;
            }
            if (event instanceof ProcessWorkItemTransitionEvent) {
                this.handleProcessWorkItemTransitionEvent((ProcessWorkItemTransitionEvent)event, userTaskInstances);
                continue;
            }
            if (event instanceof ProcessVariableChangedEvent) {
                this.handleProcessVariableChangedEvent((KogitoProcessVariableChangedEvent)event, variables);
                continue;
            }
            if (!(event instanceof HumanTaskDeadlineEvent)) continue;
            processedEvents.add(this.buildUserTaskDeadlineEvent((HumanTaskDeadlineEvent)event));
        }
        processInstances.values().stream().map(pi -> new ProcessInstanceDataEvent(this.extractRuntimeSource(pi.metaData()), this.addons.toString(), pi.metaData(), pi)).forEach(processedEvents::add);
        userTaskInstances.values().stream().map(pi -> new UserTaskInstanceDataEvent(this.extractRuntimeSource(pi.metaData()), this.addons.toString(), pi.metaData(), pi)).forEach(processedEvents::add);
        variables.stream().map(pi -> new VariableInstanceDataEvent(this.extractRuntimeSource(pi.metaData()), this.addons.toString(), pi.metaData(), pi)).forEach(processedEvents::add);
        return processedEvents;
    }

    private DataEvent<?> buildUserTaskDeadlineEvent(HumanTaskDeadlineEvent event) {
        HumanTaskWorkItem workItem = event.getWorkItem();
        KogitoWorkflowProcessInstance pi = (KogitoWorkflowProcessInstance)event.getProcessInstance();
        UserTaskDeadlineEventBody body = UserTaskDeadlineEventBody.create((String)workItem.getStringId(), (Map)event.getNotification()).state(workItem.getPhaseStatus()).taskName(workItem.getTaskName()).taskDescription(workItem.getTaskDescription()).taskPriority(workItem.getTaskPriority()).referenceName(workItem.getReferenceName()).actualOwner(workItem.getActualOwner()).startDate(workItem.getStartDate()).processInstanceId(pi.getStringId()).rootProcessInstanceId(pi.getRootProcessInstanceId()).processId(pi.getProcessId()).rootProcessId(pi.getRootProcessId()).inputs(workItem.getParameters()).outputs(workItem.getResults()).build();
        return new UserTaskDeadlineDataEvent("UserTaskDeadline" + event.getType(), this.buildSource(pi.getProcessId()), this.addons.toString(), body, pi.getStringId(), pi.getRootProcessInstanceId(), pi.getProcessId(), pi.getRootProcessId());
    }

    protected void handleProcessCompletedEvent(ProcessCompletedEvent event, ProcessInstanceEventBody body) {
        body.update().endDate(((KogitoWorkflowProcessInstance)event.getProcessInstance()).getEndDate()).state(Integer.valueOf(event.getProcessInstance().getState()));
    }

    protected void handleProcessNodeTriggeredEvent(ProcessNodeTriggeredEvent event, ProcessInstanceEventBody body) {
        NodeInstanceEventBody nodeInstanceBody = this.create((ProcessNodeEvent)event);
        if (!body.getNodeInstances().contains(nodeInstanceBody)) {
            body.update().nodeInstance(nodeInstanceBody);
        }
    }

    protected void handleProcessNodeLeftEvent(ProcessNodeLeftEvent event, ProcessInstanceEventBody body) {
        NodeInstanceEventBody nodeInstanceBody = this.create((ProcessNodeEvent)event);
        body.getNodeInstances().remove(nodeInstanceBody);
        body.update().nodeInstance(nodeInstanceBody);
    }

    protected void handleProcessWorkItemTransitionEvent(ProcessWorkItemTransitionEvent workItemTransitionEvent, Map<String, UserTaskInstanceEventBody> userTaskInstances) {
        KogitoWorkItem workItem = workItemTransitionEvent.getWorkItem();
        if (workItem instanceof HumanTaskWorkItem && workItemTransitionEvent.isTransitioned()) {
            userTaskInstances.putIfAbsent(workItem.getStringId(), this.createUserTask(workItemTransitionEvent));
        }
    }

    protected void handleProcessVariableChangedEvent(KogitoProcessVariableChangedEvent variableChangedEvent, Set<VariableInstanceEventBody> variables) {
        if (!variableChangedEvent.hasTag("internal")) {
            variables.add(this.create(variableChangedEvent));
        }
    }

    protected UserTaskInstanceEventBody createUserTask(ProcessWorkItemTransitionEvent workItemTransitionEvent) {
        KogitoWorkflowProcessInstance pi = (KogitoWorkflowProcessInstance)workItemTransitionEvent.getProcessInstance();
        HumanTaskWorkItem workItem = (HumanTaskWorkItem)workItemTransitionEvent.getWorkItem();
        return UserTaskInstanceEventBody.create().id(workItem.getStringId()).state(workItem.getPhaseStatus()).taskName(workItem.getTaskName()).taskDescription(workItem.getTaskDescription()).taskPriority(workItem.getTaskPriority()).referenceName(workItem.getReferenceName()).actualOwner(workItem.getActualOwner()).startDate(workItem.getStartDate()).completeDate(workItem.getCompleteDate()).adminGroups(workItem.getAdminGroups()).adminUsers(workItem.getAdminUsers()).excludedUsers(workItem.getExcludedUsers()).potentialGroups(workItem.getPotentialGroups()).potentialUsers(workItem.getPotentialUsers()).processInstanceId(pi.getStringId()).processInstanceVersion(pi.getProcess().getVersion()).rootProcessInstanceId(pi.getRootProcessInstanceId()).processId(pi.getProcessId()).rootProcessId(pi.getRootProcessId()).inputs(workItem.getParameters()).outputs(workItem.getResults()).comments((Collection)workItem.getComments().values().stream().map(this.createComment()).collect(Collectors.toList())).attachments((Collection)workItem.getAttachments().values().stream().map(this.createAttachment()).collect(Collectors.toList())).build();
    }

    protected Function<Comment, CommentEventBody> createComment() {
        return comment -> CommentEventBody.create().id((String)((Object)comment.getId())).content((String)((Object)comment.getContent())).updatedAt(comment.getUpdatedAt()).updatedBy(comment.getUpdatedBy()).build();
    }

    protected Function<Attachment, AttachmentEventBody> createAttachment() {
        return attachment -> AttachmentEventBody.create().id((String)((Object)attachment.getId())).name(attachment.getName()).content((URI)attachment.getContent()).updatedAt(attachment.getUpdatedAt()).updatedBy(attachment.getUpdatedBy()).build();
    }

    protected ProcessInstanceEventBody create(ProcessEvent event) {
        String securityRoles;
        KogitoWorkflowProcessInstance pi = (KogitoWorkflowProcessInstance)event.getProcessInstance();
        ProcessInstanceEventBody.Builder eventBuilder = ProcessInstanceEventBody.create().id(pi.getStringId()).version(pi.getProcess().getVersion()).parentInstanceId(pi.getParentProcessInstanceId()).rootInstanceId(pi.getRootProcessInstanceId()).processId(pi.getProcessId()).rootProcessId(pi.getRootProcessId()).processName(pi.getProcessName()).startDate(pi.getStartDate()).endDate(pi.getEndDate()).state(Integer.valueOf(pi.getState())).businessKey(pi.getCorrelationKey()).variables(pi.getVariables()).milestones(this.createMilestones(pi));
        if (pi.getState() == 5) {
            eventBuilder.error(ProcessErrorEventBody.create().nodeDefinitionId(pi.getNodeIdInError()).errorMessage(pi.getErrorMessage()).build());
        }
        if ((securityRoles = (String)pi.getProcess().getMetaData().get("securityRoles")) != null) {
            eventBuilder.roles(securityRoles.split(","));
        }
        return eventBuilder.build();
    }

    protected Set<MilestoneEventBody> createMilestones(KogitoWorkflowProcessInstance pi) {
        if (pi.milestones() == null) {
            return null;
        }
        return pi.milestones().stream().map(m -> MilestoneEventBody.create().id(m.getId()).name(m.getName()).status(m.getStatus().name()).build()).collect(Collectors.toSet());
    }

    protected NodeInstanceEventBody create(ProcessNodeEvent event) {
        KogitoNodeInstance ni = (KogitoNodeInstance)event.getNodeInstance();
        return NodeInstanceEventBody.create().id(ni.getStringId()).nodeId(String.valueOf(ni.getNodeId())).nodeDefinitionId(ni.getNodeDefinitionId()).nodeName(ni.getNodeName()).nodeType(ni.getNode().getClass().getSimpleName()).triggerTime(ni.getTriggerTime()).leaveTime(ni.getLeaveTime()).build();
    }

    protected VariableInstanceEventBody create(KogitoProcessVariableChangedEvent event) {
        KogitoProcessInstance pi = (KogitoProcessInstance)event.getProcessInstance();
        VariableInstanceEventBody.Builder eventBuilder = VariableInstanceEventBody.create().changeDate(event.getEventDate()).processId(pi.getProcessId()).processInstanceId(pi.getStringId()).rootProcessId(pi.getRootProcessId()).rootProcessInstanceId(pi.getRootProcessInstanceId()).variableName(event.getVariableId()).variableValue(event.getNewValue()).variablePreviousValue(event.getOldValue());
        if (event.getNodeInstance() != null) {
            eventBuilder.changedByNodeId(event.getNodeInstance().getNodeDefinitionId()).changedByNodeName(event.getNodeInstance().getNodeName()).changedByNodeType(event.getNodeInstance().getNode().getClass().getSimpleName());
        }
        return eventBuilder.build();
    }

    protected String extractRuntimeSource(Map<String, String> metadata) {
        return this.buildSource(metadata.get("kogito.processinstance.processId"));
    }

    private String buildSource(String processId) {
        if (processId == null) {
            return null;
        }
        return this.service + "/" + (processId.contains(".") ? processId.substring(processId.lastIndexOf(46) + 1) : processId);
    }
}

