/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.event.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.kie.kogito.event.EventMarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringEventMarshaller
implements EventMarshaller<String> {
    private static final Logger logger = LoggerFactory.getLogger(StringEventMarshaller.class);
    private final ObjectMapper mapper;

    public StringEventMarshaller(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public <T> String marshall(T event) {
        logger.debug("Marshalling event {}", event);
        try {
            return this.mapper.writeValueAsString(event);
        }
        catch (JsonProcessingException e) {
            logger.error("Error marshalling event {}", event);
            throw new IllegalStateException(e);
        }
    }
}

