/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.drools.ruleunits.api.RuleUnitInstance;

public class Executor {
    private final ExecutorService executorService;

    public static Executor create(ExecutorService executorService) {
        return new Executor(executorService);
    }

    public static Executor create() {
        return Executor.create(Executors.newSingleThreadExecutor());
    }

    private Executor(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public Future<Integer> submit(RuleUnitInstance<?> instance) {
        return this.executorService.submit(() -> {
            int result = instance.fire();
            this.submit(instance);
            return result;
        });
    }
}

