/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.jobs.impl;

import java.util.Objects;
import java.util.Optional;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.Signal;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.timer.TimerInstance;
import org.kie.kogito.uow.UnitOfWorkManager;

public class TriggerJobCommand {
    private String processInstanceId;
    private String correlationId;
    private String timerId;
    private Integer limit;
    private Process<?> process;
    private UnitOfWorkManager uom;
    public static final String SIGNAL = "timerTriggered";

    public TriggerJobCommand(String processInstanceId, String correlationId, String timerId, Integer limit, Process<?> process, UnitOfWorkManager uom) {
        this.processInstanceId = processInstanceId;
        this.correlationId = correlationId;
        this.timerId = timerId;
        this.limit = limit;
        this.process = process;
        this.uom = uom;
    }

    public boolean execute() {
        return UnitOfWorkExecutor.executeInUnitOfWork(this.uom, () -> {
            Optional processInstanceFound = this.process.instances().findById(this.processInstanceId);
            return processInstanceFound.map(processInstance -> {
                processInstance.send((Signal)new JobSignal(SIGNAL, TimerInstance.with((String)this.correlationId, (String)this.timerId, (Integer)this.limit)));
                return true;
            }).orElse(false);
        });
    }

    private class JobSignal
    implements Signal<Object> {
        private String signal;
        private Object payload;

        public JobSignal(String signal, Object payload) {
            this.signal = signal;
            this.payload = payload;
        }

        public String channel() {
            return this.signal;
        }

        public Object payload() {
            return this.payload;
        }

        public String referenceId() {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof JobSignal)) {
                return false;
            }
            JobSignal jobSignal = (JobSignal)o;
            return Objects.equals(this.signal, jobSignal.signal) && Objects.equals(this.payload, jobSignal.payload);
        }

        public int hashCode() {
            return Objects.hash(this.signal, this.payload);
        }
    }
}

