/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.event.impl;

import java.util.Optional;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.event.EventReceiver;
import org.kie.kogito.event.InputTriggerAware;
import org.kie.kogito.event.SubscriptionInfo;
import org.kie.kogito.process.Process;
import org.kie.kogito.services.event.AbstractProcessDataEvent;
import org.kie.kogito.services.event.EventConsumer;
import org.kie.kogito.services.event.EventConsumerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageConsumer<M extends Model, D, T extends AbstractProcessDataEvent<D>>
implements InputTriggerAware {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMessageConsumer.class);
    private Process<M> process;
    private Application application;
    private String trigger;
    private EventConsumer<M> eventConsumer;

    public AbstractMessageConsumer() {
    }

    public AbstractMessageConsumer(Application application, Process<M> process, String trigger, EventConsumerFactory eventConsumerFactory, EventReceiver eventReceiver, Class<D> dataEventClass, Class<T> cloudEventClass, boolean useCloudEvents) {
        this.init(application, process, trigger, eventConsumerFactory, eventReceiver, dataEventClass, cloudEventClass, useCloudEvents);
    }

    public void init(Application application, Process<M> process, String trigger, EventConsumerFactory eventConsumerFactory, EventReceiver eventReceiver, Class<D> dataEventClass, Class<T> cloudEventClass, boolean useCloudEvents) {
        this.process = process;
        this.application = application;
        this.trigger = trigger;
        this.eventConsumer = eventConsumerFactory.get(this::eventToModel, useCloudEvents);
        if (useCloudEvents) {
            eventReceiver.subscribe(this::consumeCloud, new SubscriptionInfo(cloudEventClass, Optional.of(trigger)));
        } else {
            eventReceiver.subscribe(this::consume, new SubscriptionInfo(dataEventClass, Optional.of(trigger)));
        }
        logger.info("Consumer for {} started.", dataEventClass);
    }

    public void consumeCloud(T payload) {
        logger.debug("Received: {} on thread {}", payload, (Object)Thread.currentThread().getName());
        this.eventConsumer.consume(this.application, this.process, payload, this.trigger);
    }

    public void consume(D payload) {
        logger.debug("Received: {} on thread {}", payload, (Object)Thread.currentThread().getName());
        this.eventConsumer.consume(this.application, this.process, payload, this.trigger);
    }

    public String getInputTrigger() {
        return this.trigger;
    }

    protected abstract M eventToModel(D var1);
}

