/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.jobs.impl;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.kie.kogito.jobs.JobDescription;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.services.jobs.impl.JobExecutorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryJobService
implements JobsService,
AutoCloseable {
    public static final String IN_MEMORY_JOB_SERVICE_POOL_SIZE_PROPERTY = "kogito.in-memory.job-service.pool-size";
    private static final Logger LOGGER = LoggerFactory.getLogger(InMemoryJobService.class);
    protected ScheduledExecutorService scheduler;
    protected ConcurrentHashMap<String, ScheduledFuture<?>> scheduledJobs = new ConcurrentHashMap();
    protected List<JobExecutorFactory> jobExecutorFactories = new ArrayList<JobExecutorFactory>();

    public InMemoryJobService() {
        this(new ScheduledThreadPoolExecutor(Integer.parseInt(System.getProperty(IN_MEMORY_JOB_SERVICE_POOL_SIZE_PROPERTY, "10"))));
    }

    public InMemoryJobService(ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
    }

    public InMemoryJobService registerJobExecutorFactory(JobExecutorFactory jobExecutorFactory) {
        Iterator<JobExecutorFactory> iterator = this.jobExecutorFactories.iterator();
        while (iterator.hasNext()) {
            JobExecutorFactory factory = iterator.next();
            if (!factory.types().containsAll(jobExecutorFactory.types())) continue;
            iterator.remove();
        }
        this.jobExecutorFactories.add(jobExecutorFactory);
        return this;
    }

    public String scheduleJob(JobDescription jobDescription) {
        LOGGER.debug("ScheduleProcessJob: {}", (Object)jobDescription);
        long delay = this.calculateDelay(jobDescription);
        Long interval = jobDescription.expirationTime().repeatInterval();
        Optional<JobExecutorFactory> jobExecutorFactoryFound = this.findJobExecutorFactory(jobDescription);
        if (jobExecutorFactoryFound.isEmpty()) {
            throw new IllegalArgumentException("Could not schedule " + jobDescription + ". No job executor factory provided");
        }
        JobExecutorFactory jobExecutorFactory = jobExecutorFactoryFound.get();
        ScheduledFuture<?> future = interval != null ? this.scheduler.scheduleAtFixedRate(jobExecutorFactory.createNewRepeteableRunnable(this, jobDescription), delay, interval, TimeUnit.MILLISECONDS) : this.scheduler.schedule(jobExecutorFactory.createNewRunnable(this, jobDescription), delay, TimeUnit.MILLISECONDS);
        this.scheduledJobs.put(jobDescription.id(), future);
        return jobDescription.id();
    }

    private Optional<JobExecutorFactory> findJobExecutorFactory(JobDescription jobDescription) {
        return this.jobExecutorFactories.stream().filter(factory -> factory.accept(jobDescription)).findFirst();
    }

    public boolean cancelJob(String id) {
        return this.cancelJob(id, false);
    }

    public boolean cancelJob(String id, boolean force) {
        ScheduledFuture<?> future;
        LOGGER.debug("Cancel Job: {}", (Object)id);
        if (this.scheduledJobs.containsKey(id) && !(future = this.scheduledJobs.remove(id)).isDone()) {
            return future.cancel(force);
        }
        return false;
    }

    protected long calculateDelay(JobDescription description) {
        long delay = Duration.between(ZonedDateTime.now(), description.expirationTime().get()).toMillis();
        if (delay <= 0L) {
            return 1L;
        }
        return delay;
    }

    @Override
    public void close() throws Exception {
        LOGGER.info("closing in memory job service");
        this.scheduledJobs.clear();
        this.scheduledJobs.forEach((k, v) -> v.cancel(true));
        this.scheduler.shutdownNow();
    }

    public void clearJobExecutorFactories() {
        this.jobExecutorFactories.clear();
    }
}

