/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.jobs.impl;

import java.util.Set;
import org.kie.kogito.jobs.JobDescription;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.jobs.descriptors.ProcessInstanceJobDescription;
import org.kie.kogito.jobs.descriptors.ProcessJobDescription;
import org.kie.kogito.services.jobs.impl.InMemoryJobContext;
import org.kie.kogito.services.jobs.impl.JobExecutorFactory;
import org.kie.kogito.services.jobs.impl.SignalProcessInstanceOnExpiredTimer;
import org.kie.kogito.services.jobs.impl.StartProcessOnExpiredTimer;

public class InMemoryProcessJobExecutorFactory
implements JobExecutorFactory {
    private InMemoryJobContext jobsConfiguration;

    public InMemoryProcessJobExecutorFactory(InMemoryJobContext jobsConfiguration) {
        this.jobsConfiguration = jobsConfiguration;
    }

    @Override
    public Set<Class<? extends JobDescription>> types() {
        return Set.of(ProcessInstanceJobDescription.class, ProcessJobDescription.class);
    }

    @Override
    public Runnable createNewRunnable(JobsService jobService, JobDescription jobDescription) {
        if (jobDescription instanceof ProcessInstanceJobDescription) {
            ProcessInstanceJobDescription processInstanceJobDescription = (ProcessInstanceJobDescription)jobDescription;
            return this.processInstanceJobDescription(jobService, this.jobsConfiguration, processInstanceJobDescription, true, 1);
        }
        if (jobDescription instanceof ProcessJobDescription) {
            ProcessJobDescription processJobDescription = (ProcessJobDescription)jobDescription;
            return this.processJobByDescription(jobService, this.jobsConfiguration, processJobDescription);
        }
        throw new IllegalArgumentException("single job description not supported for " + jobDescription);
    }

    @Override
    public Runnable createNewRepeteableRunnable(JobsService jobService, JobDescription jobDescription) {
        if (jobDescription instanceof ProcessInstanceJobDescription) {
            ProcessInstanceJobDescription processInstanceJobDescription = (ProcessInstanceJobDescription)jobDescription;
            return this.processInstanceJobDescription(jobService, this.jobsConfiguration, processInstanceJobDescription, false, processInstanceJobDescription.expirationTime().repeatLimit());
        }
        if (jobDescription instanceof ProcessJobDescription) {
            ProcessJobDescription processJobDescription = (ProcessJobDescription)jobDescription;
            return this.repeatableJobByDescription(jobService, this.jobsConfiguration, processJobDescription);
        }
        throw new IllegalArgumentException("repeteable job description not supported for " + jobDescription);
    }

    protected Runnable processInstanceJobDescription(JobsService jobService, InMemoryJobContext jobsConfiguration, ProcessInstanceJobDescription description, boolean remove, int limit) {
        return new SignalProcessInstanceOnExpiredTimer(jobService, jobsConfiguration, description.id(), description.timerId(), description.processInstanceId(), remove, limit);
    }

    protected Runnable processJobByDescription(JobsService jobService, InMemoryJobContext jobsConfiguration, ProcessJobDescription description) {
        return new StartProcessOnExpiredTimer(jobService, jobsConfiguration, description.id(), description.process(), true, -1);
    }

    protected Runnable repeatableJobByDescription(JobsService jobService, InMemoryJobContext jobsConfiguration, ProcessJobDescription description) {
        return new StartProcessOnExpiredTimer(jobService, jobsConfiguration, description.id(), description.process(), false, description.expirationTime().repeatLimit());
    }
}

