/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.jobs.impl;

import java.util.Set;
import org.kie.kogito.jobs.JobDescription;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.jobs.descriptors.UserTaskInstanceJobDescription;
import org.kie.kogito.services.jobs.impl.InMemoryJobContext;
import org.kie.kogito.services.jobs.impl.JobExecutorFactory;
import org.kie.kogito.services.jobs.impl.SignalUserTaskInstanceOnExpiredTimer;

public class InMemoryUserTaskJobExecutorFactory
implements JobExecutorFactory {
    private InMemoryJobContext jobsConfiguration;

    public InMemoryUserTaskJobExecutorFactory(InMemoryJobContext jobsConfiguration) {
        this.jobsConfiguration = jobsConfiguration;
    }

    @Override
    public Set<Class<? extends JobDescription>> types() {
        return Set.of(UserTaskInstanceJobDescription.class);
    }

    @Override
    public Runnable createNewRunnable(JobsService jobService, JobDescription jobDescription) {
        if (jobDescription instanceof UserTaskInstanceJobDescription) {
            UserTaskInstanceJobDescription userTaskInstanceJobDescription = (UserTaskInstanceJobDescription)jobDescription;
            return this.userTaskJobDescription(jobService, this.jobsConfiguration, userTaskInstanceJobDescription);
        }
        throw new IllegalArgumentException("single job description not supported for " + jobDescription);
    }

    @Override
    public Runnable createNewRepeteableRunnable(JobsService jobService, JobDescription jobDescription) {
        if (jobDescription instanceof UserTaskInstanceJobDescription) {
            UserTaskInstanceJobDescription userTaskInstanceJobDescription = (UserTaskInstanceJobDescription)jobDescription;
            return this.repetableUserTaskJobDescription(jobService, this.jobsConfiguration, userTaskInstanceJobDescription);
        }
        throw new IllegalArgumentException("repeteable job description not supported for " + jobDescription);
    }

    private Runnable userTaskJobDescription(JobsService jobService, InMemoryJobContext jobsConfiguration, UserTaskInstanceJobDescription userTaskInstanceJobDescription) {
        return new SignalUserTaskInstanceOnExpiredTimer(jobService, jobsConfiguration, userTaskInstanceJobDescription, true, -1);
    }

    private Runnable repetableUserTaskJobDescription(JobsService jobService, InMemoryJobContext jobsConfiguration, UserTaskInstanceJobDescription userTaskInstanceJobDescription) {
        return new SignalUserTaskInstanceOnExpiredTimer(jobService, jobsConfiguration, userTaskInstanceJobDescription, false, userTaskInstanceJobDescription.expirationTime().repeatLimit());
    }
}

