/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.jobs.impl;

import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.jobs.JobDescription;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.jobs.descriptors.ProcessInstanceJobDescription;
import org.kie.kogito.jobs.descriptors.ProcessJobDescription;
import org.kie.kogito.services.jobs.impl.InMemoryJobContext;
import org.kie.kogito.services.jobs.impl.JobExecutorFactory;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.timer.TimerInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyInMemoryJobExecutorFactory
implements JobExecutorFactory {
    private static final String TRIGGER = "timer";
    private static Logger LOGGER = LoggerFactory.getLogger(LegacyInMemoryJobExecutorFactory.class);
    private InMemoryJobContext jobsConfiguration;

    public LegacyInMemoryJobExecutorFactory(InMemoryJobContext jobsConfiguration) {
        this.jobsConfiguration = jobsConfiguration;
    }

    @Override
    public Set<Class<? extends JobDescription>> types() {
        return Set.of(ProcessInstanceJobDescription.class, ProcessJobDescription.class);
    }

    @Override
    public Runnable createNewRunnable(JobsService jobService, JobDescription jobDescription) {
        if (jobDescription instanceof ProcessInstanceJobDescription) {
            ProcessInstanceJobDescription processInstanceJobDescription = (ProcessInstanceJobDescription)jobDescription;
            return this.processInstanceJobDescription(jobService, this.jobsConfiguration, processInstanceJobDescription, true, 1);
        }
        if (jobDescription instanceof ProcessJobDescription) {
            ProcessJobDescription processJobDescription = (ProcessJobDescription)jobDescription;
            return this.processJobByDescription(jobService, this.jobsConfiguration, processJobDescription);
        }
        throw new IllegalArgumentException("single job description not supported for " + jobDescription);
    }

    @Override
    public Runnable createNewRepeteableRunnable(JobsService jobService, JobDescription jobDescription) {
        if (jobDescription instanceof ProcessInstanceJobDescription) {
            ProcessInstanceJobDescription processInstanceJobDescription = (ProcessInstanceJobDescription)jobDescription;
            return this.processInstanceJobDescription(jobService, this.jobsConfiguration, processInstanceJobDescription, false, processInstanceJobDescription.expirationTime().repeatLimit());
        }
        if (jobDescription instanceof ProcessJobDescription) {
            ProcessJobDescription processJobDescription = (ProcessJobDescription)jobDescription;
            return this.repeatableJobByDescription(jobService, this.jobsConfiguration, processJobDescription);
        }
        throw new IllegalArgumentException("multiple job description not supported for " + jobDescription);
    }

    protected Runnable processInstanceJobDescription(JobsService jobService, InMemoryJobContext jobsConfiguration, ProcessInstanceJobDescription description, boolean remove, int limit) {
        String id = description.id();
        AtomicInteger counter = new AtomicInteger(limit);
        return () -> {
            try {
                UnitOfWorkExecutor.executeInUnitOfWork(jobsConfiguration.unitOfWorkManager(), () -> {
                    KogitoProcessInstance pi = jobsConfiguration.runtime().getProcessInstance(description.processInstanceId());
                    if (pi != null) {
                        pi.signalEvent("timerTriggered", (Object)TimerInstance.with((String)description.id(), (String)description.timerId(), (Integer)counter.decrementAndGet()));
                        if (counter.get() == 0) {
                            jobService.cancelJob(id);
                        }
                    } else {
                        jobService.cancelJob(id);
                    }
                    return null;
                });
                LOGGER.debug("Job {} completed", (Object)id);
            }
            finally {
                if (remove) {
                    jobService.cancelJob(id);
                }
            }
        };
    }

    protected Runnable processJobByDescription(JobsService jobService, InMemoryJobContext jobsConfiguration, ProcessJobDescription description) {
        return this.processCommand(jobService, jobsConfiguration, description, true);
    }

    protected Runnable repeatableJobByDescription(JobsService jobService, InMemoryJobContext jobsConfiguration, ProcessJobDescription description) {
        return this.processCommand(jobService, jobsConfiguration, description, false);
    }

    private Runnable processCommand(JobsService jobService, InMemoryJobContext jobsConfiguration, ProcessJobDescription description, boolean remove) {
        String id = description.id();
        AtomicInteger counter = new AtomicInteger(description.expirationTime().repeatLimit());
        String processId = description.processId();
        return () -> {
            try {
                LOGGER.debug("Job {} started", (Object)id);
                UnitOfWorkExecutor.executeInUnitOfWork(jobsConfiguration.unitOfWorkManager(), () -> {
                    KogitoProcessInstance pi = jobsConfiguration.runtime().createProcessInstance(processId, null);
                    if (pi != null) {
                        jobsConfiguration.runtime().startProcessInstance(pi.getStringId(), TRIGGER);
                    }
                    return null;
                });
                if (counter.decrementAndGet() == 0) {
                    jobService.cancelJob(id);
                }
                LOGGER.debug("Job {} completed", (Object)id);
            }
            finally {
                if (remove) {
                    jobService.cancelJob(id);
                }
            }
        };
    }
}

