/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.jobs.impl;

import java.util.Optional;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstanceOptimisticLockingException;
import org.kie.kogito.services.jobs.impl.InMemoryJobContext;
import org.kie.kogito.services.jobs.impl.TriggerJobCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SignalProcessInstanceOnExpiredTimer
implements Runnable {
    private static Logger LOGGER = LoggerFactory.getLogger(SignalProcessInstanceOnExpiredTimer.class);
    private final String id;
    private final String timerId;
    private boolean removeAtExecution;
    private String processInstanceId;
    private Integer limit;
    private JobsService jobService;
    private InMemoryJobContext jobsConfiguration;

    public SignalProcessInstanceOnExpiredTimer(JobsService jobService, InMemoryJobContext jobsConfiguration, String id, String timerId, String processInstanceId, boolean removeAtExecution, Integer limit) {
        this.id = id;
        this.timerId = timerId;
        this.processInstanceId = processInstanceId;
        this.removeAtExecution = removeAtExecution;
        this.limit = limit;
        this.jobsConfiguration = jobsConfiguration;
        this.jobService = jobService;
    }

    @Override
    public void run() {
        try {
            Optional process = this.jobsConfiguration.processes().processByProcessInstanceId(this.processInstanceId);
            if (process.isEmpty()) {
                LOGGER.info("Skipping Job {}. There is no process for pid {} ", (Object)this.id, (Object)this.processInstanceId);
                return;
            }
            LOGGER.info("Job {} started", (Object)this.id);
            Integer n = this.limit;
            this.limit = this.limit - 1;
            boolean executed = new TriggerJobCommand(this.processInstanceId, this.id, this.timerId, this.limit, (Process)process.get(), this.jobsConfiguration.unitOfWorkManager()).execute();
            if (this.limit == 0 || !executed) {
                this.jobService.cancelJob(this.id);
            }
            LOGGER.debug("Job {} completed", (Object)this.id);
        }
        catch (ProcessInstanceOptimisticLockingException ex) {
            LOGGER.info("Retrying Job {} due to: {}", (Object)this.id, (Object)ex.getMessage());
            Integer n = this.limit;
            this.limit = this.limit + 1;
            this.run();
        }
        finally {
            if (this.removeAtExecution) {
                this.jobService.cancelJob(this.id);
            }
        }
    }
}

