/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.jobs.impl;

import java.util.Optional;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.jobs.descriptors.UserTaskInstanceJobDescription;
import org.kie.kogito.process.ProcessInstanceOptimisticLockingException;
import org.kie.kogito.services.jobs.impl.InMemoryJobContext;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.usertask.UserTaskInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SignalUserTaskInstanceOnExpiredTimer
implements Runnable {
    private static Logger LOGGER = LoggerFactory.getLogger(SignalUserTaskInstanceOnExpiredTimer.class);
    private boolean removeAtExecution;
    private Integer limit;
    private JobsService jobService;
    private InMemoryJobContext jobsConfiguration;
    private UserTaskInstanceJobDescription userTaskInstanceJobDescription;

    public SignalUserTaskInstanceOnExpiredTimer(JobsService jobService, InMemoryJobContext jobsConfiguration, UserTaskInstanceJobDescription userTaskInstanceJobDescription, boolean removeAtExecution, Integer limit) {
        this.userTaskInstanceJobDescription = userTaskInstanceJobDescription;
        this.removeAtExecution = removeAtExecution;
        this.limit = limit;
        this.jobsConfiguration = jobsConfiguration;
        this.jobService = jobService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String jobId = this.userTaskInstanceJobDescription.id();
        String userTaskInstanceId = this.userTaskInstanceJobDescription.userTaskInstanceId();
        try {
            Optional userTaskInstance = this.jobsConfiguration.userTasks().instances().findById(userTaskInstanceId);
            if (userTaskInstance.isEmpty()) {
                LOGGER.info("Skipping Job {}. There is no user task instance of id {} ", (Object)jobId, (Object)userTaskInstanceId);
                return;
            }
            Integer n = this.limit;
            this.limit = this.limit - 1;
            UnitOfWorkExecutor.executeInUnitOfWork(this.jobsConfiguration.unitOfWorkManager(), () -> {
                ((UserTaskInstance)userTaskInstance.get()).trigger(this.userTaskInstanceJobDescription);
                return null;
            });
            if (this.limit == 0) {
                this.jobService.cancelJob(jobId);
            }
            LOGGER.debug("Job {} completed", (Object)jobId);
        }
        catch (ProcessInstanceOptimisticLockingException ex) {
            LOGGER.info("Retrying Job {} due to: {}", (Object)jobId, (Object)ex.getMessage());
            Integer n = this.limit;
            this.limit = this.limit + 1;
            this.run();
        }
        finally {
            if (this.removeAtExecution) {
                this.jobService.cancelJob(jobId);
            }
        }
    }
}

