/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.jobs.impl;

import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.services.jobs.impl.InMemoryJobContext;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StartProcessOnExpiredTimer
implements Runnable {
    private static Logger LOGGER = LoggerFactory.getLogger(StartProcessOnExpiredTimer.class);
    private static final String TRIGGER = "timer";
    private final String id;
    private boolean removeAtExecution;
    private Process process;
    private Integer limit;
    private JobsService jobService;
    private InMemoryJobContext jobsConfiguration;

    public StartProcessOnExpiredTimer(JobsService jobService, InMemoryJobContext jobsConfiguration, String id, Process<?> process, boolean removeAtExecution, Integer limit) {
        this.id = id;
        this.process = process;
        this.removeAtExecution = removeAtExecution;
        this.limit = limit;
        this.jobsConfiguration = jobsConfiguration;
        this.jobService = jobService;
    }

    @Override
    public void run() {
        try {
            LOGGER.debug("Job {} started", (Object)this.id);
            UnitOfWorkExecutor.executeInUnitOfWork(this.jobsConfiguration.unitOfWorkManager(), () -> {
                ProcessInstance pi = this.process.createInstance(this.process.createModel());
                if (pi != null) {
                    pi.start(TRIGGER, null);
                }
                return null;
            });
            Integer n = this.limit;
            this.limit = this.limit - 1;
            if (this.limit == 0) {
                this.jobService.cancelJob(this.id);
            }
            LOGGER.debug("Job {} completed", (Object)this.id);
        }
        finally {
            if (this.removeAtExecution) {
                this.jobService.cancelJob(this.id);
            }
        }
    }
}

