/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.source.files;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.kie.kogito.internal.SupportedExtensions;
import org.kie.kogito.source.files.SourceFile;
import org.kie.kogito.source.files.SourceFilesProvider;

public final class SourceFilesProviderImpl
implements SourceFilesProvider {
    private final Map<String, Collection<SourceFile>> sourceFiles = new HashMap<String, Collection<SourceFile>>();

    public void addSourceFile(String id, SourceFile sourceFile) {
        this.sourceFiles.computeIfAbsent(id, k -> new HashSet()).add(sourceFile);
    }

    public Optional<SourceFile> getSourceFilesByUri(String uri) {
        return this.sourceFiles.values().stream().flatMap(Collection::stream).filter(file -> Objects.equals(file.getUri(), uri)).findFirst();
    }

    public Collection<SourceFile> getProcessSourceFiles(String processId) {
        return this.sourceFiles.getOrDefault(processId, Set.of());
    }

    public Optional<SourceFile> getProcessSourceFile(String processId) {
        return this.getProcessSourceFiles(processId).stream().filter(this::isValidDefinitionSource).findFirst();
    }

    private boolean isValidDefinitionSource(SourceFile sourceFile) {
        return SupportedExtensions.isSourceFile((String)sourceFile.getUri());
    }
}

