/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.timer.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.Callable;
import org.kie.kogito.timer.InternalSchedulerService;
import org.kie.kogito.timer.Job;
import org.kie.kogito.timer.JobContext;
import org.kie.kogito.timer.JobHandle;
import org.kie.kogito.timer.Trigger;
import org.kie.kogito.timer.impl.TimerJobInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTimerJobInstance
implements Callable<Void>,
Comparable<DefaultTimerJobInstance>,
TimerJobInstance,
Serializable {
    private static final long serialVersionUID = -4441139572159254264L;
    protected static final transient Logger logger = LoggerFactory.getLogger(DefaultTimerJobInstance.class);
    private final Job job;
    private final Trigger trigger;
    private final JobContext ctx;
    protected transient InternalSchedulerService scheduler;
    private final JobHandle handle;

    public DefaultTimerJobInstance(Job job, JobContext ctx, Trigger trigger, JobHandle handle, InternalSchedulerService scheduler) {
        this.job = job;
        this.ctx = ctx;
        this.trigger = trigger;
        this.handle = handle;
        this.scheduler = scheduler;
    }

    @Override
    public int compareTo(DefaultTimerJobInstance o) {
        return this.trigger.hasNextFireTime().compareTo(o.getTrigger().hasNextFireTime());
    }

    @Override
    public Void call() throws Exception {
        try {
            this.trigger.nextFireTime();
            if (this.handle.isCancel()) {
                return null;
            }
            this.job.execute(this.ctx);
            if (this.handle.isCancel()) {
                return null;
            }
            Date date = this.trigger.hasNextFireTime();
            if (date != null) {
                this.scheduler.internalSchedule(this);
            }
        }
        catch (Exception e) {
            logger.warn("Unable to execute timer job!", (Throwable)e);
            throw e;
        }
        return null;
    }

    @Override
    public JobHandle getJobHandle() {
        return this.handle;
    }

    @Override
    public Job getJob() {
        return this.job;
    }

    @Override
    public Trigger getTrigger() {
        return this.trigger;
    }

    @Override
    public JobContext getJobContext() {
        return this.ctx;
    }
}

