/*
 * Copyright 2020 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kie.kogito.timer;

public interface SchedulerService<T extends JobHandle> {

    /**
     * Schedule a job for later execution
     *
     * @param job
     * @param ctx
     * @param trigger
     *
     * @return
     */
    T scheduleJob(Job job, JobContext ctx, Trigger trigger);

    /**
     * Remove the job identified by the given job handle from the 
     * scheduled queue
     *
     * @param jobHandle the job identity handle
     *
     * @return
     */
    boolean removeJob(T jobHandle);
}
