/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.timer.impl;

import java.util.Collection;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.kie.kogito.timer.InternalSchedulerService;
import org.kie.kogito.timer.Job;
import org.kie.kogito.timer.JobContext;
import org.kie.kogito.timer.JobHandle;
import org.kie.kogito.timer.SessionClock;
import org.kie.kogito.timer.TimerService;
import org.kie.kogito.timer.Trigger;
import org.kie.kogito.timer.impl.DefaultJobHandle;
import org.kie.kogito.timer.impl.DefaultTimerJobFactoryManager;
import org.kie.kogito.timer.impl.TimerJobFactoryManager;
import org.kie.kogito.timer.impl.TimerJobInstance;

public class JDKTimerService
implements TimerService,
SessionClock,
InternalSchedulerService {
    private final int size;
    private AtomicLong idCounter;
    protected ScheduledThreadPoolExecutor scheduler;
    protected TimerJobFactoryManager jobFactoryManager = DefaultTimerJobFactoryManager.instance;

    public JDKTimerService() {
        this(1);
    }

    public JDKTimerService(int size) {
        this.size = size;
        this.scheduler = new ScheduledThreadPoolExecutor(size);
        this.idCounter = new AtomicLong(0L);
    }

    @Override
    public void setTimerJobFactoryManager(TimerJobFactoryManager timerJobFactoryManager) {
        this.jobFactoryManager = timerJobFactoryManager;
    }

    @Override
    public TimerJobFactoryManager getTimerJobFactoryManager() {
        return this.jobFactoryManager;
    }

    @Override
    public long getCurrentTime() {
        return System.currentTimeMillis();
    }

    @Override
    public void reset() {
        if (this.idCounter.get() != 0L) {
            this.scheduler.shutdownNow();
            this.scheduler = new ScheduledThreadPoolExecutor(this.size);
            this.idCounter.set(0L);
        }
    }

    @Override
    public void shutdown() {
        this.scheduler.shutdownNow();
    }

    @Override
    public JobHandle scheduleJob(Job job, JobContext ctx, Trigger trigger) {
        Date date = trigger.hasNextFireTime();
        if (date != null) {
            JDKJobHandle jobHandle = new JDKJobHandle(this.idCounter.getAndIncrement());
            TimerJobInstance jobInstance = this.jobFactoryManager.createTimerJobInstance(job, ctx, trigger, jobHandle, this);
            jobHandle.setTimerJobInstance(jobInstance);
            this.internalSchedule(jobInstance);
            return jobHandle;
        }
        return null;
    }

    @Override
    public void internalSchedule(TimerJobInstance timerJobInstance) {
        Date date = timerJobInstance.getTrigger().hasNextFireTime();
        Callable item = (Callable)((Object)timerJobInstance);
        JDKJobHandle jobHandle = (JDKJobHandle)timerJobInstance.getJobHandle();
        long then = date.getTime();
        long now = System.currentTimeMillis();
        ScheduledFuture<Void> future = null;
        future = then >= now ? this.scheduler.schedule(item, then - now, TimeUnit.MILLISECONDS) : this.scheduler.schedule(item, 0L, TimeUnit.MILLISECONDS);
        jobHandle.setFuture(future);
        this.jobFactoryManager.addTimerJobInstance(timerJobInstance);
    }

    @Override
    public boolean removeJob(JobHandle jobHandle) {
        jobHandle.setCancel(true);
        JDKJobHandle jdkJobHandle = (JDKJobHandle)jobHandle;
        this.jobFactoryManager.removeTimerJobInstance(jdkJobHandle.getTimerJobInstance());
        return this.scheduler.remove((Runnable)((Object)jdkJobHandle.getFuture()));
    }

    @Override
    public long getTimeToNextJob() {
        return 0L;
    }

    @Override
    public Collection<TimerJobInstance> getTimerJobInstances(long id) {
        return this.jobFactoryManager.getTimerJobInstances();
    }

    public static class JDKJobHandle
    extends DefaultJobHandle {
        private static final long serialVersionUID = 510L;
        private ScheduledFuture<Void> future;

        public JDKJobHandle(long id) {
            super(id);
        }

        public ScheduledFuture<Void> getFuture() {
            return this.future;
        }

        public void setFuture(ScheduledFuture<Void> future) {
            this.future = future;
        }
    }
}

