/*
 * Decompiled with CFR 0.152.
 */
package org.kie.addons.monitoring.rule;

import io.prometheus.client.Histogram;
import org.drools.core.event.rule.impl.AfterActivationFiredEventImpl;
import org.drools.core.event.rule.impl.BeforeActivationFiredEventImpl;
import org.kie.addons.monitoring.rule.PrometheusMetrics;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.event.rule.DefaultAgendaEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusMetricsDroolsListener
extends DefaultAgendaEventListener {
    private static final Logger logger = LoggerFactory.getLogger(PrometheusMetricsDroolsListener.class);
    private final String identifier;

    public PrometheusMetricsDroolsListener(String identifier) {
        this.identifier = identifier;
    }

    public void beforeMatchFired(BeforeMatchFiredEvent event) {
        long nanoTime = System.nanoTime();
        BeforeActivationFiredEventImpl impl = this.getBeforeImpl(event);
        impl.setTimestamp(nanoTime);
    }

    public void afterMatchFired(AfterMatchFiredEvent event) {
        AfterActivationFiredEventImpl afterImpl = this.getAfterImpl(event);
        BeforeActivationFiredEventImpl beforeImpl = this.getBeforeImpl(afterImpl.getBeforeMatchFiredEvent());
        long startTime = beforeImpl.getTimestamp();
        long elapsed = System.nanoTime() - startTime;
        String ruleName = event.getMatch().getRule().getName();
        ((Histogram.Child)PrometheusMetrics.getDroolsEvaluationTimeHistogram().labels(new String[]{this.identifier, ruleName})).observe((double)elapsed);
        if (logger.isDebugEnabled()) {
            logger.debug("Elapsed time: " + elapsed);
        }
    }

    public BeforeActivationFiredEventImpl getBeforeImpl(BeforeMatchFiredEvent e) {
        return (BeforeActivationFiredEventImpl)e;
    }

    public AfterActivationFiredEventImpl getAfterImpl(AfterMatchFiredEvent e) {
        return (AfterActivationFiredEventImpl)e;
    }
}

