/*
 * Decompiled with CFR 0.152.
 */
package org.kie.addons.monitoring.process;

import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Summary;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.SLAViolatedEvent;
import org.kie.api.runtime.process.NodeInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusProcessEventListener
extends DefaultProcessEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrometheusProcessEventListener.class);
    protected static final Counter numberOfProcessInstancesStarted = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("kie_process_instance_started_total")).help("Started Process Instances")).labelNames(new String[]{"app_id", "process_id"})).register();
    protected static final Counter numberOfSLAsViolated = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("kie_process_instance_sla_violated_total")).help("Process Instances SLA Violated")).labelNames(new String[]{"app_id", "process_id", "node_name"})).register();
    protected static final Counter numberOfProcessInstancesCompleted = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("kie_process_instance_completed_total")).help("Completed Process Instances")).labelNames(new String[]{"app_id", "process_id", "status"})).register();
    protected static final Gauge runningProcessInstances = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("kie_process_instance_running_total")).help("Running Process Instances")).labelNames(new String[]{"app_id", "process_id"})).register();
    protected static final Summary processInstancesDuration = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name("kie_process_instance_duration_seconds")).help("Process Instances Duration")).labelNames(new String[]{"app_id", "process_id"})).register();
    protected static final Summary workItemsDuration = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name("kie_work_item_duration_seconds")).help("Work Items Duration")).labelNames(new String[]{"name"})).register();
    private String identifier;

    protected static void recordRunningProcessInstance(String containerId, String processId) {
        ((Gauge.Child)runningProcessInstances.labels(new String[]{containerId, processId})).inc();
    }

    public PrometheusProcessEventListener(String identifier) {
        this.identifier = identifier;
    }

    public void afterProcessStarted(ProcessStartedEvent event) {
        LOGGER.debug("After process started event: {}", (Object)event);
        WorkflowProcessInstanceImpl processInstance = (WorkflowProcessInstanceImpl)event.getProcessInstance();
        ((Counter.Child)numberOfProcessInstancesStarted.labels(new String[]{this.identifier, processInstance.getProcessId()})).inc();
        PrometheusProcessEventListener.recordRunningProcessInstance(this.identifier, processInstance.getProcessId());
    }

    public void afterProcessCompleted(ProcessCompletedEvent event) {
        LOGGER.debug("After process completed event: {}", (Object)event);
        WorkflowProcessInstanceImpl processInstance = (WorkflowProcessInstanceImpl)event.getProcessInstance();
        ((Gauge.Child)runningProcessInstances.labels(new String[]{this.identifier, processInstance.getProcessId()})).dec();
        ((Counter.Child)numberOfProcessInstancesCompleted.labels(new String[]{this.identifier, processInstance.getProcessId(), String.valueOf(processInstance.getState())})).inc();
        if (processInstance.getStartDate() != null) {
            double duration = PrometheusProcessEventListener.millisToSeconds(processInstance.getEndDate().getTime() - processInstance.getStartDate().getTime());
            ((Summary.Child)processInstancesDuration.labels(new String[]{this.identifier, processInstance.getProcessId()})).observe(duration);
            LOGGER.debug("Process Instance duration: {}s", (Object)duration);
        }
    }

    public void beforeNodeLeft(ProcessNodeLeftEvent event) {
        WorkItemNodeInstance wi;
        LOGGER.debug("Before Node left event: {}", (Object)event);
        NodeInstance nodeInstance = event.getNodeInstance();
        if (nodeInstance instanceof WorkItemNodeInstance && (wi = (WorkItemNodeInstance)nodeInstance).getTriggerTime() != null) {
            String name = wi.getWorkItem().getParameters().getOrDefault("TaskName", wi.getWorkItem().getName());
            double duration = PrometheusProcessEventListener.millisToSeconds(wi.getLeaveTime().getTime() - wi.getTriggerTime().getTime());
            ((Summary.Child)workItemsDuration.labels(new String[]{name})).observe(duration);
            LOGGER.debug("Work Item {}, duration: {}s", (Object)name, (Object)duration);
        }
    }

    public void afterSLAViolated(SLAViolatedEvent event) {
        LOGGER.debug("After SLA violated event: {}", (Object)event);
        WorkflowProcessInstanceImpl processInstance = (WorkflowProcessInstanceImpl)event.getProcessInstance();
        if (processInstance != null && event.getNodeInstance() != null) {
            ((Counter.Child)numberOfSLAsViolated.labels(new String[]{this.identifier, processInstance.getProcessId(), event.getNodeInstance().getNodeName()})).inc();
        }
    }

    protected static double millisToSeconds(long millis) {
        return (double)millis / 1000.0;
    }
}

