package org.kie.kogito.app;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.kogito.decision.DecisionConfig;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.rules.RuleConfig;

@org.springframework.stereotype.Component()
public class ApplicationConfig implements org.kie.kogito.Config {

    protected ProcessConfig processConfig;

    protected RuleConfig ruleConfig;

    protected DecisionConfig decisionConfig;

    private org.kie.kogito.process.WorkItemHandlerConfig defaultWorkItemHandlerConfig = new org.kie.kogito.process.impl.DefaultWorkItemHandlerConfig();

    private org.kie.kogito.uow.UnitOfWorkManager defaultUnitOfWorkManager = new org.kie.kogito.services.uow.DefaultUnitOfWorkManager(new org.kie.kogito.services.uow.CollectingUnitOfWorkFactory());

    private org.kie.kogito.jobs.JobsService defaultJobsService = null;

    @org.springframework.beans.factory.annotation.Autowired()
    java.util.Optional<org.kie.kogito.process.WorkItemHandlerConfig> workItemHandlerConfig;

    @org.springframework.beans.factory.annotation.Autowired()
    java.util.Optional<org.kie.kogito.uow.UnitOfWorkManager> unitOfWorkManager;

    @org.springframework.beans.factory.annotation.Autowired()
    java.util.Optional<org.kie.kogito.jobs.JobsService> jobsService;

    @org.springframework.beans.factory.annotation.Autowired(required = false)
    java.util.Collection<org.kie.kogito.process.ProcessEventListenerConfig> processEventListenerConfigs;

    @org.springframework.beans.factory.annotation.Autowired(required = false)
    java.util.Collection<org.kie.api.event.process.ProcessEventListener> processEventListeners;

    @Override
    public ProcessConfig process() {
        return processConfig;
    }

    @Override
    public RuleConfig rule() {
        return ruleConfig;
    }

    @Override
    public DecisionConfig decision() {
        return decisionConfig;
    }

    private static <C, L> List<L> merge(Collection<C> configs, Function<C, Collection<L>> configToListeners, Collection<L> listeners) {
        return Stream.concat(configs.stream().flatMap(c -> configToListeners.apply(c).stream()), listeners.stream()).collect(Collectors.toList());
    }

    protected org.kie.kogito.process.WorkItemHandlerConfig extract_workItemHandlerConfig() {
        if (workItemHandlerConfig.isPresent())
            return workItemHandlerConfig.get();
        else
            return defaultWorkItemHandlerConfig;
    }

    protected org.kie.kogito.uow.UnitOfWorkManager extract_unitOfWorkManager() {
        if (unitOfWorkManager.isPresent())
            return unitOfWorkManager.get();
        else
            return defaultUnitOfWorkManager;
    }

    protected org.kie.kogito.jobs.JobsService extract_jobsService() {
        if (jobsService.isPresent())
            return jobsService.get();
        else
            return defaultJobsService;
    }

    private org.kie.kogito.process.ProcessEventListenerConfig extract_processEventListenerConfig() {
        return this.merge_processEventListenerConfig(processEventListenerConfigs != null ? processEventListenerConfigs : java.util.Collections.emptyList(), processEventListeners != null ? processEventListeners : java.util.Collections.emptyList());
    }

    private org.kie.kogito.process.ProcessEventListenerConfig merge_processEventListenerConfig(java.util.Collection<org.kie.kogito.process.ProcessEventListenerConfig> processEventListenerConfigs, java.util.Collection<org.kie.api.event.process.ProcessEventListener> processEventListeners) {
        return new org.kie.kogito.process.impl.CachedProcessEventListenerConfig(merge(processEventListenerConfigs, org.kie.kogito.process.ProcessEventListenerConfig::listeners, processEventListeners));
    }

    public org.kie.kogito.Addons addons() {
        return new org.kie.kogito.Addons(java.util.Arrays.asList("infinispan-persistence"));
    }

    @javax.annotation.PostConstruct()
    public void init() {
        processConfig = new org.kie.kogito.process.impl.StaticProcessConfig(extract_workItemHandlerConfig(), extract_processEventListenerConfig(), extract_unitOfWorkManager(), extract_jobsService());
        ruleConfig = null;
        decisionConfig = null;
    }
}
