package org.kie.kogito.test;

import java.util.TimeZone;
import java.util.Optional;
import org.kie.kogito.Application;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.impl.Sig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import org.kie.kogito.test.TravelersModel;

@org.springframework.stereotype.Component()
public class TravelersMessageConsumer_3 {

    private static final Logger LOGGER = LoggerFactory.getLogger("MessageConsumer");

    @org.springframework.beans.factory.annotation.Autowired()
    @org.springframework.beans.factory.annotation.Qualifier("Travelers")
    Process<TravelersModel> process;

    @org.springframework.beans.factory.annotation.Autowired()
    Application application;

    @org.springframework.beans.factory.annotation.Value("${kogito.messaging.as-cloudevents:#{null}}")
    Optional<Boolean> useCloudEvents = Optional.of(true);

    private ObjectMapper json = new ObjectMapper();

    {
        json.setDateFormat(new StdDateFormat().withColonInTimeZone(true).withTimeZone(TimeZone.getDefault()));
    }

    @javax.annotation.PostConstruct()
    public void configure() {
    }

    @org.springframework.kafka.annotation.KafkaListener(topics = "travellers")
    public void consume(String payload) {
        final String trigger = "travellers";
        try {
            if (useCloudEvents.orElse(true)) {
                final TravelersMessageDataEvent_3 eventData = json.readValue(payload, TravelersMessageDataEvent_3.class);
                final TravelersModel model = new TravelersModel();
                model.setTraveller(eventData.getData());
                org.kie.kogito.services.uow.UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
                    if (eventData.getKogitoReferenceId() != null) {
                        LOGGER.debug("Received message with reference id '{}' going to use it to send signal '{}'", eventData.getKogitoReferenceId(), trigger);
                        process.instances().findById(eventData.getKogitoReferenceId()).ifPresent(pi -> pi.send(Sig.of("Message-" + trigger, eventData.getData(), eventData.getKogitoProcessinstanceId())));
                    } else {
                        LOGGER.debug("Received message without reference id, staring new process instance with trigger '{}'", trigger);
                        ProcessInstance<TravelersModel> pi = process.createInstance(model);
                        if (eventData.getKogitoStartFromNode() != null) {
                            pi.startFrom(eventData.getKogitoStartFromNode(), eventData.getKogitoProcessinstanceId());
                        } else {
                            pi.start(trigger, eventData.getKogitoProcessinstanceId());
                        }
                    }
                    return null;
                });
            } else {
                final org.acme.travel.Traveller eventData = json.readValue(payload, org.acme.travel.Traveller.class);
                final TravelersModel model = new TravelersModel();
                model.setTraveller(eventData);
                org.kie.kogito.services.uow.UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
                    LOGGER.debug("Received message without reference id, staring new process instance with trigger '{}'", trigger);
                    ProcessInstance<TravelersModel> pi = process.createInstance(model);
                    pi.start(trigger, null);
                    return null;
                });
            }
        } catch (Exception e) {
            LOGGER.error("Error when consuming message for process {}", process.id(), e);
        }
    }
}
