package org.kie.kogito.test;

import java.util.Optional;
import java.util.TimeZone;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.kogito.event.DataEvent;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import com.github.javaparser.ast.body.MethodDeclaration;

@org.springframework.stereotype.Component()
public class TravelersMessageProducer_7 {

    @org.springframework.beans.factory.annotation.Autowired()
    org.springframework.kafka.core.KafkaTemplate<String, String> emitter;

    @org.springframework.beans.factory.annotation.Value("${kogito.messaging.as-cloudevents:#{null}}")
    Optional<Boolean> useCloudEvents = Optional.of(true);

    private ObjectMapper json = new ObjectMapper();

    {
        json.setDateFormat(new StdDateFormat().withColonInTimeZone(true).withTimeZone(TimeZone.getDefault()));
    }

    @javax.annotation.PostConstruct()
    public void configure() {
    }

    public void produce(ProcessInstance pi, org.acme.travel.Traveller eventData) {
        emitter.send("processedtravellers", this.marshall(pi, eventData));
    }

    private String marshall(ProcessInstance pi, org.acme.travel.Traveller eventData) {
        try {
            if (useCloudEvents.orElse(true)) {
                TravelersMessageDataEvent_7 event = new TravelersMessageDataEvent_7("", eventData, pi.getId(), pi.getParentProcessInstanceId(), pi.getRootProcessInstanceId(), pi.getProcessId(), pi.getRootProcessId(), String.valueOf(pi.getState()));
                if (pi.getReferenceId() != null && !pi.getReferenceId().isEmpty()) {
                    event.setKogitoReferenceId(pi.getReferenceId());
                }
                return json.writeValueAsString(event);
            } else {
                return json.writeValueAsString(eventData);
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
