/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.test;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.text.DateFormat;
import java.util.Optional;
import java.util.TimeZone;
import javax.annotation.PostConstruct;
import org.acme.travel.Traveller;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.kogito.test.TravelersMessageDataEvent_7;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Component;

@Component
public class TravelersMessageProducer_7 {
    @Autowired
    KafkaTemplate<String, String> emitter;
    @Value(value="${kogito.messaging.as-cloudevents:#{null}}")
    Optional<Boolean> useCloudEvents = Optional.of(true);
    private ObjectMapper json = new ObjectMapper();

    public TravelersMessageProducer_7() {
        this.json.setDateFormat((DateFormat)new StdDateFormat().withColonInTimeZone(true).withTimeZone(TimeZone.getDefault()));
    }

    @PostConstruct
    public void configure() {
    }

    public void produce(ProcessInstance pi, Traveller eventData) {
        this.emitter.send("processedtravellers", (Object)this.marshall(pi, eventData));
    }

    private String marshall(ProcessInstance pi, Traveller eventData) {
        try {
            if (this.useCloudEvents.orElse(true).booleanValue()) {
                TravelersMessageDataEvent_7 event = new TravelersMessageDataEvent_7("", eventData, pi.getId(), pi.getParentProcessInstanceId(), pi.getRootProcessInstanceId(), pi.getProcessId(), pi.getRootProcessId(), String.valueOf(pi.getState()));
                if (pi.getReferenceId() != null && !pi.getReferenceId().isEmpty()) {
                    event.setKogitoReferenceId(pi.getReferenceId());
                }
                return this.json.writeValueAsString((Object)event);
            }
            return this.json.writeValueAsString((Object)eventData);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

