/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.test;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.kie.kogito.Application;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessError;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceExecutionException;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.services.identity.StaticIdentityProvider;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.test.TravelersModel;
import org.kie.kogito.test.TravelersModelInput;
import org.kie.kogito.test.TravelersModelOutput;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Path(value="/Travelers")
@Component
public class TravelersResource {
    @Autowired
    @Qualifier(value="Travelers")
    Process<TravelersModel> process;
    @Autowired
    Application application;

    @GET
    @Produces(value={"application/json"})
    public List<TravelersModelOutput> getResources_Travelers() {
        return this.process.instances().values().stream().map(pi -> this.mapOutput(new TravelersModelOutput(), (TravelersModel)pi.variables())).collect(Collectors.toList());
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public TravelersModelOutput getResource_Travelers(@PathParam(value="id") String id) {
        return this.process.instances().findById(id).map(pi -> this.mapOutput(new TravelersModelOutput(), (TravelersModel)pi.variables())).orElse(null);
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public TravelersModelOutput deleteResource_Travelers(@PathParam(value="id") String id) {
        return (TravelersModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance pi = this.process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            pi.abort();
            return this.getModel(pi);
        });
    }

    @POST
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public TravelersModelOutput updateModel_Travelers(@PathParam(value="id") String id, TravelersModel resource) {
        return (TravelersModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance pi = this.process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            pi.updateVariables((Object)resource);
            return this.mapOutput(new TravelersModelOutput(), (TravelersModel)pi.variables());
        });
    }

    @GET
    @Path(value="/{id}/tasks")
    @Produces(value={"application/json"})
    public Map<String, String> getTasks_Travelers(@PathParam(value="id") String id, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return this.process.instances().findById(id).map(pi -> pi.workItems(this.policies(user, groups))).map(l -> l.stream().collect(Collectors.toMap(WorkItem::getId, WorkItem::getName))).orElse(null);
    }

    protected TravelersModelOutput getModel(ProcessInstance<TravelersModel> pi) {
        if (pi.status() == 5 && pi.error().isPresent()) {
            throw new ProcessInstanceExecutionException(pi.id(), ((ProcessError)pi.error().get()).failedNodeId(), ((ProcessError)pi.error().get()).errorMessage());
        }
        return this.mapOutput(new TravelersModelOutput(), (TravelersModel)pi.variables());
    }

    protected Policy[] policies(String user, List<String> groups) {
        if (user == null) {
            return new Policy[0];
        }
        StaticIdentityProvider identity = null;
        if (user != null) {
            identity = new StaticIdentityProvider(user, groups);
        }
        return new Policy[]{SecurityPolicy.of((IdentityProvider)identity)};
    }

    protected TravelersModel mapInput(@Valid @NotNull TravelersModelInput input, TravelersModel resource) {
        resource.fromMap(input.toMap());
        return resource;
    }

    protected TravelersModelOutput mapOutput(TravelersModelOutput output, TravelersModel resource) {
        output.fromMap(resource.getId(), resource.toMap());
        return output;
    }
}

