package org.kie.kogito.test;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import org.kie.api.runtime.process.ProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Optional;
import java.util.TimeZone;

@org.springframework.stereotype.Component()
public class TravelersMessageProducer_7 {

    @org.springframework.beans.factory.annotation.Autowired()
    org.springframework.kafka.core.KafkaTemplate<String, String> emitter;

    @org.springframework.beans.factory.annotation.Value("${kogito.messaging.as-cloudevents:#{null}}")
    Optional<Boolean> useCloudEvents = Optional.of(true);

    private ObjectMapper json = new ObjectMapper();

    private static final Logger LOGGER = LoggerFactory.getLogger("MessageProducer");

    {
        json.setDateFormat(new StdDateFormat().withColonInTimeZone(true).withTimeZone(TimeZone.getDefault()));
    }

    @javax.annotation.PostConstruct()
    public void configure() {
    }

    public void produce(ProcessInstance pi, org.acme.travel.Traveller eventData) {
        emitter.send("processedtravellers", this.marshall(pi, eventData));
    }

    private String marshall(ProcessInstance pi, org.acme.travel.Traveller eventData) {
        try {
            if (useCloudEvents.orElse(true)) {
                TravelersMessageDataEvent_7 event = new TravelersMessageDataEvent_7("", eventData, pi.getId(), pi.getParentProcessInstanceId(), pi.getRootProcessInstanceId(), pi.getProcessId(), pi.getRootProcessId(), String.valueOf(pi.getState()));
                if (pi.getReferenceId() != null && !pi.getReferenceId().isEmpty()) {
                    event.setKogitoReferenceId(pi.getReferenceId());
                }
                final String eventString = json.writeValueAsString(event);
                LOGGER.debug("CloudEvent marshalled, sending: {}", eventString);
                return eventString;
            } else {
                final String eventString = json.writeValueAsString(eventData);
                LOGGER.debug("Event marshalled, sending: {}", eventString);
                return eventString;
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
