package org.kie.kogito.test;

import java.util.Optional;
import org.kie.kogito.Application;
import org.kie.kogito.process.Process;
import org.kie.kogito.services.event.EventConsumerFactory;
import org.kie.kogito.event.impl.DefaultEventConsumerFactory;

@org.springframework.stereotype.Component()
public class TravelersMessageConsumer_3 {

    @org.springframework.beans.factory.annotation.Autowired()
    @org.springframework.beans.factory.annotation.Qualifier("Travelers")
    Process<TravelersModel> process;

    @org.springframework.beans.factory.annotation.Autowired()
    Application application;

    @org.springframework.beans.factory.annotation.Value("${kogito.messaging.as-cloudevents:#{null}}")
    Optional<Boolean> useCloudEvents = Optional.of(true);

    EventConsumerFactory eventConsumerFactory = new DefaultEventConsumerFactory();

    @javax.annotation.PostConstruct()
    public void configure() {
    }

    @org.springframework.kafka.annotation.KafkaListener(topics = "travellers")
    public void consume(String payload) {
        eventConsumerFactory.get(event -> {
            TravelersModel model = new TravelersModel();
            model.setTraveller(event);
            return model;
        }, org.acme.travel.Traveller.class, TravelersMessageDataEvent_3.class, useCloudEvents).consume(application, process, payload, "travellers");
    }
}
