package org.kie.kogito.test;

import java.util.Optional;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.kogito.event.impl.DefaultEventMarshaller;
import org.kie.kogito.services.event.EventMarshaller;

@org.springframework.stereotype.Component()
public class TravelersMessageProducer_7 {

    @org.springframework.beans.factory.annotation.Autowired()
    org.springframework.kafka.core.KafkaTemplate<String, String> emitter;

    @org.springframework.beans.factory.annotation.Value("${kogito.messaging.as-cloudevents:#{null}}")
    Optional<Boolean> useCloudEvents = Optional.of(true);

    EventMarshaller marshaller = new DefaultEventMarshaller();

    @javax.annotation.PostConstruct()
    public void configure() {
    }

    public void produce(ProcessInstance pi, org.acme.travel.Traveller eventData) {
        emitter.send("processedtravellers", this.marshall(pi, eventData));
    }

    private String marshall(ProcessInstance pi, org.acme.travel.Traveller eventData) {
        return marshaller.marshall(eventData, e -> new TravelersMessageDataEvent_7("", e, pi.getId(), pi.getParentProcessInstanceId(), pi.getRootProcessInstanceId(), pi.getProcessId(), pi.getRootProcessId(), String.valueOf(pi.getState()), pi.getReferenceId() == null || pi.getReferenceId().trim().isEmpty() ? null : pi.getReferenceId()), useCloudEvents);
    }
}
