/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.app;

import java.util.Arrays;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.drools.core.config.DefaultRuleEventListenerConfig;
import org.drools.core.config.StaticRuleConfig;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.kogito.Addons;
import org.kie.kogito.Config;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.process.ProcessEventListenerConfig;
import org.kie.kogito.process.WorkItemHandlerConfig;
import org.kie.kogito.process.impl.DefaultProcessEventListenerConfig;
import org.kie.kogito.process.impl.DefaultWorkItemHandlerConfig;
import org.kie.kogito.process.impl.StaticProcessConfig;
import org.kie.kogito.rules.RuleConfig;
import org.kie.kogito.rules.RuleEventListenerConfig;
import org.kie.kogito.services.uow.CollectingUnitOfWorkFactory;
import org.kie.kogito.services.uow.DefaultUnitOfWorkManager;
import org.kie.kogito.uow.UnitOfWorkFactory;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplicationConfig
implements Config {
    protected ProcessConfig processConfig;
    protected RuleConfig ruleConfig;
    private ProcessEventListenerConfig defaultProcessEventListenerConfig = new DefaultProcessEventListenerConfig(new ProcessEventListener[0]);
    private WorkItemHandlerConfig defaultWorkItemHandlerConfig = new DefaultWorkItemHandlerConfig();
    private UnitOfWorkManager defaultUnitOfWorkManager = new DefaultUnitOfWorkManager((UnitOfWorkFactory)new CollectingUnitOfWorkFactory());
    private JobsService defaultJobsService = null;
    @Autowired
    Optional<ProcessEventListenerConfig> processEventListenerConfig;
    @Autowired
    Optional<WorkItemHandlerConfig> workItemHandlerConfig;
    @Autowired
    Optional<UnitOfWorkManager> unitOfWorkManager;
    @Autowired
    Optional<JobsService> jobsService;
    private RuleEventListenerConfig defaultRuleEventListenerConfig = new DefaultRuleEventListenerConfig();
    @Autowired
    Optional<RuleEventListenerConfig> ruleEventListenerConfig;

    public ProcessConfig process() {
        return this.processConfig;
    }

    public RuleConfig rule() {
        return this.ruleConfig;
    }

    protected WorkItemHandlerConfig extract_workItemHandlerConfig() {
        if (this.workItemHandlerConfig.isPresent()) {
            return (WorkItemHandlerConfig)this.workItemHandlerConfig.get();
        }
        return this.defaultWorkItemHandlerConfig;
    }

    protected ProcessEventListenerConfig extract_processEventListenerConfig() {
        if (this.processEventListenerConfig.isPresent()) {
            return (ProcessEventListenerConfig)this.processEventListenerConfig.get();
        }
        return this.defaultProcessEventListenerConfig;
    }

    protected UnitOfWorkManager extract_unitOfWorkManager() {
        if (this.unitOfWorkManager.isPresent()) {
            return (UnitOfWorkManager)this.unitOfWorkManager.get();
        }
        return this.defaultUnitOfWorkManager;
    }

    protected JobsService extract_jobsService() {
        if (this.jobsService.isPresent()) {
            return (JobsService)this.jobsService.get();
        }
        return this.defaultJobsService;
    }

    protected RuleEventListenerConfig extract_ruleEventListenerConfig() {
        if (this.ruleEventListenerConfig.isPresent()) {
            return (RuleEventListenerConfig)this.ruleEventListenerConfig.get();
        }
        return this.defaultRuleEventListenerConfig;
    }

    public Addons addons() {
        return new Addons(Arrays.asList(new String[0]));
    }

    @PostConstruct
    public void init() {
        this.processConfig = new StaticProcessConfig(this.extract_workItemHandlerConfig(), this.extract_processEventListenerConfig(), this.extract_unitOfWorkManager(), this.extract_jobsService());
        this.ruleConfig = new StaticRuleConfig(this.extract_ruleEventListenerConfig());
    }
}

