package org.kie.kogito.app;

import java.util.ArrayList;
import java.util.List;
import org.kie.kogito.event.CloudEventMeta;
import org.kie.kogito.event.Topic;
import org.kie.kogito.event.TopicDiscovery;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/messaging/topics")
@org.springframework.stereotype.Component()
public class TopicsInformationResource {

    @org.springframework.beans.factory.annotation.Autowired()
    TopicDiscovery discovery;

    private List<CloudEventMeta> eventsMeta;

    public TopicsInformationResource() {
        eventsMeta = new ArrayList<>();
        eventsMeta.add(new CloudEventMeta("travellers", "", org.kie.kogito.event.EventKind.CONSUMED));
        eventsMeta.add(new CloudEventMeta("process.travelers.processedtravellers", "/process/travelers", org.kie.kogito.event.EventKind.PRODUCED));
    }

    @GetMapping(produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<List<Topic>> getTopics() {
        return ResponseEntity.ok(discovery.getTopics(eventsMeta));
    }
}
