package org.kie.kogito.test;

import org.kie.kogito.Application;
import org.kie.kogito.conf.ConfigBean;
import org.kie.kogito.event.KogitoEventStreams;
import org.kie.kogito.event.impl.DefaultEventConsumerFactory;
import org.kie.kogito.process.Process;
import org.kie.kogito.services.event.impl.AbstractMessageConsumer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@org.springframework.stereotype.Component()
public class TravelersMessageConsumer_3 extends AbstractMessageConsumer<TravelersModel, org.acme.travel.Traveller, TravelersMessageDataEvent_3> {

    @org.springframework.beans.factory.annotation.Autowired()
    TravelersMessageConsumer_3(Application application, @org.springframework.beans.factory.annotation.Qualifier("Travelers") Process<TravelersModel> process, ConfigBean configBean, @org.springframework.beans.factory.annotation.Qualifier(KogitoEventStreams.PUBLISHER) Publisher<String> eventPublisher) {
        super(application, process, org.acme.travel.Traveller.class, TravelersMessageDataEvent_3.class, "travellers", new DefaultEventConsumerFactory(), configBean.useCloudEvents());
        Flux.from(eventPublisher).subscribe(this::consume);
    }

    protected TravelersModel eventToModel(org.acme.travel.Traveller event) {
        TravelersModel model = new TravelersModel();
        model.setTraveller(event);
        return model;
    }
}
