package org.kie.kogito.test;

import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.ruleflow.core.RuleFlowProcessFactory;
import org.drools.core.util.KieFunctions;

@org.springframework.stereotype.Component("Travelers")
public class TravelersProcess extends org.kie.kogito.process.impl.AbstractProcess<org.kie.kogito.test.TravelersModel> {

    @org.springframework.beans.factory.annotation.Autowired()
    org.kie.kogito.test.TravelersMessageProducer_7 producer_7;

    @org.springframework.beans.factory.annotation.Autowired()
    public TravelersProcess(org.kie.kogito.app.Application app) {
        super(app, java.util.Arrays.asList());
        activate();
    }

    public TravelersProcess() {
    }

    @Override()
    public org.kie.kogito.test.TravelersProcessInstance createInstance(org.kie.kogito.test.TravelersModel value) {
        return new org.kie.kogito.test.TravelersProcessInstance(this, value, this.createProcessRuntime());
    }

    public org.kie.kogito.test.TravelersProcessInstance createInstance(java.lang.String businessKey, org.kie.kogito.test.TravelersModel value) {
        return new org.kie.kogito.test.TravelersProcessInstance(this, value, businessKey, this.createProcessRuntime());
    }

    @Override()
    public org.kie.kogito.test.TravelersModel createModel() {
        return new org.kie.kogito.test.TravelersModel();
    }

    public org.kie.kogito.test.TravelersProcessInstance createInstance(org.kie.kogito.Model value) {
        return this.createInstance((org.kie.kogito.test.TravelersModel) value);
    }

    public org.kie.kogito.test.TravelersProcessInstance createInstance(java.lang.String businessKey, org.kie.kogito.Model value) {
        return this.createInstance(businessKey, (org.kie.kogito.test.TravelersModel) value);
    }

    public org.kie.kogito.test.TravelersProcessInstance createInstance(org.kie.api.runtime.process.WorkflowProcessInstance wpi) {
        return new org.kie.kogito.test.TravelersProcessInstance(this, this.createModel(), this.createProcessRuntime(), wpi);
    }

    public org.kie.kogito.test.TravelersProcessInstance createReadOnlyInstance(org.kie.api.runtime.process.WorkflowProcessInstance wpi) {
        return new org.kie.kogito.test.TravelersProcessInstance(this, this.createModel(), wpi);
    }

    public org.kie.api.definition.process.Process process() {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess("Travelers");
        factory.variable("traveller", new ObjectDataType("org.acme.travel.Traveller"), "customTags", null);
        factory.name("Process travelers");
        factory.packageName("org.kie.kogito.test");
        factory.dynamic(false);
        factory.version("1.0");
        factory.visibility("Public");
        factory.metaData("TargetNamespace", "http://www.omg.org/bpmn20");
        org.jbpm.ruleflow.core.factory.ActionNodeFactory actionNode1 = factory.actionNode(1);
        actionNode1.name("Skip Traveler");
        actionNode1.action(kcontext -> {
            org.acme.travel.Traveller traveller = (org.acme.travel.Traveller) kcontext.getVariable("traveller");
            System.out.println("Skipping traveller " + traveller);
        });
        actionNode1.metaData("UniqueId", "_0C615323-1520-40BF-8A41-46C2BBC6819C");
        actionNode1.metaData("elementname", "Skip Traveler");
        actionNode1.metaData("NodeType", "ScriptTask");
        actionNode1.metaData("x", 1018);
        actionNode1.metaData("width", 154);
        actionNode1.metaData("y", 361);
        actionNode1.metaData("height", 102);
        actionNode1.done();
        org.jbpm.ruleflow.core.factory.ActionNodeFactory actionNode2 = factory.actionNode(2);
        actionNode2.name("Log Traveler");
        actionNode2.action(kcontext -> {
            org.acme.travel.Traveller traveller = (org.acme.travel.Traveller) kcontext.getVariable("traveller");
            System.out.println("Processing traveller " + traveller);
        });
        actionNode2.metaData("UniqueId", "_B7417363-C542-4A4A-A314-2AF370DE2515");
        actionNode2.metaData("elementname", "Log Traveler");
        actionNode2.metaData("NodeType", "ScriptTask");
        actionNode2.metaData("x", 1018);
        actionNode2.metaData("width", 154);
        actionNode2.metaData("y", 170);
        actionNode2.metaData("height", 102);
        actionNode2.done();
        org.jbpm.ruleflow.core.factory.StartNodeFactory startNode3 = factory.startNode(3);
        startNode3.name("travelers");
        startNode3.interrupting(false);
        startNode3.metaData("TriggerMapping", "traveller");
        startNode3.metaData("UniqueId", "_8BEA9396-93DE-4D44-8CE2-4A146464264E");
        startNode3.metaData("elementname", "travelers");
        startNode3.metaData("TriggerType", "ConsumeMessage");
        startNode3.metaData("x", 520);
        startNode3.metaData("width", 56);
        startNode3.metaData("y", 193);
        startNode3.metaData("TriggerRef", "travellers");
        startNode3.metaData("MessageType", "org.acme.travel.Traveller");
        startNode3.metaData("height", 56);
        startNode3.done();
        startNode3.trigger("travellers", "traveller", "event");
        org.jbpm.ruleflow.core.factory.RuleSetNodeFactory ruleSetNode4 = factory.ruleSetNode(4);
        ruleSetNode4.name("Process Traveler");
        ruleSetNode4.inMapping("traveller", "traveller");
        ruleSetNode4.outMapping("traveller", "traveller");
        ruleSetNode4.ruleFlowGroup("travellers", () -> {
            return org.drools.project.model.ProjectRuntime.INSTANCE.newKieSession("defaultStatelessKieSession", app.config().get(org.kie.kogito.rules.RuleConfig.class));
        });
        ruleSetNode4.metaData("UniqueId", "_60FA6326-76DC-4DB2-AB06-DB8AC8EE8DC8");
        ruleSetNode4.metaData("elementname", "Process Traveler");
        ruleSetNode4.metaData("x", 648);
        ruleSetNode4.metaData("width", 154);
        ruleSetNode4.metaData("y", 170);
        ruleSetNode4.metaData("customAsync", "true");
        ruleSetNode4.metaData("height", 102);
        ruleSetNode4.done();
        org.jbpm.ruleflow.core.factory.SplitFactory splitNode5 = factory.splitNode(5);
        splitNode5.name("Processed Traveler?");
        splitNode5.type(2);
        splitNode5.metaData("UniqueId", "_58FF9DA5-06C6-4D71-91CD-6EAE4E999CF9");
        splitNode5.metaData("elementname", "Processed Traveler?");
        splitNode5.metaData("x", 882);
        splitNode5.metaData("width", 56);
        splitNode5.metaData("y", 193);
        splitNode5.metaData("height", 56);
        splitNode5.constraint(1, "_EDFD7D46-79EC-4C49-B6D8-5873E9301AC7", "DROOLS_DEFAULT", "java", kcontext -> {
            org.acme.travel.Traveller traveller = (org.acme.travel.Traveller) kcontext.getVariable("traveller");
            return !traveller.isProcessed();
        }, 0);
        splitNode5.constraint(2, "_C5756B00-2541-4948-A7F5-4494A10E3A31", "DROOLS_DEFAULT", "java", kcontext -> {
            org.acme.travel.Traveller traveller = (org.acme.travel.Traveller) kcontext.getVariable("traveller");
            return traveller.isProcessed();
        }, 0);
        splitNode5.done();
        org.jbpm.ruleflow.core.factory.EndNodeFactory endNode6 = factory.endNode(6);
        endNode6.name("skipTraveler");
        endNode6.terminate(true);
        endNode6.metaData("UniqueId", "_F368D316-78E0-4D1C-A59A-79BC75A0A62B");
        endNode6.metaData("elementname", "skipTraveler");
        endNode6.metaData("x", 1252);
        endNode6.metaData("width", 56);
        endNode6.metaData("y", 384);
        endNode6.metaData("height", 56);
        endNode6.done();
        org.jbpm.ruleflow.core.factory.EndNodeFactory endNode7 = factory.endNode(7);
        endNode7.name("processedtraveler");
        endNode7.terminate(false);
        endNode7.action(kcontext -> {
            org.acme.travel.Traveller object = (org.acme.travel.Traveller) kcontext.getVariable("traveller");
            org.drools.core.common.InternalKnowledgeRuntime runtime = (org.drools.core.common.InternalKnowledgeRuntime) kcontext.getKieRuntime();
            org.kie.kogito.internal.process.runtime.KogitoProcessInstance pi = (org.kie.kogito.internal.process.runtime.KogitoProcessInstance) kcontext.getProcessInstance();
            org.jbpm.process.instance.InternalProcessRuntime process = (org.jbpm.process.instance.InternalProcessRuntime) runtime.getProcessRuntime();
            process.getProcessEventSupport().fireOnMessage(pi, kcontext.getNodeInstance(), runtime, "processedtravellers", object);
            producer_7.produce(pi, object);
        });
        endNode7.metaData("UniqueId", "_0E0784C3-1BEC-4A51-A5E6-D7E5DA3A4402");
        endNode7.metaData("elementname", "processedtraveler");
        endNode7.metaData("TriggerType", "ProduceMessage");
        endNode7.metaData("x", 1252);
        endNode7.metaData("width", 56);
        endNode7.metaData("y", 193);
        endNode7.metaData("TriggerRef", "processedtravellers");
        endNode7.metaData("MappingVariable", "traveller");
        endNode7.metaData("MessageType", "org.acme.travel.Traveller");
        endNode7.metaData("height", 56);
        endNode7.done();
        factory.connection(5, 1, "_EDFD7D46-79EC-4C49-B6D8-5873E9301AC7");
        factory.connection(5, 2, "_C5756B00-2541-4948-A7F5-4494A10E3A31");
        factory.connection(3, 4, "_D15CD483-D31D-42F8-A93A-AAAF44292D84");
        factory.connection(4, 5, "_96F8E118-C58C-4369-89DC-2C881614FF73");
        factory.connection(1, 6, "_5CC19845-48FB-4E72-BD04-E392C0241209");
        factory.connection(2, 7, "_6ED9B3DA-9FD9-49F3-A70E-A6AB6712A628");
        factory.validate();
        return factory.getProcess();
    }
}
